/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DeclarationList {
    private final List<VariableDeclaration> declarations;

    public DeclarationList() {
        this.declarations = Collections.emptyList();
    }

    public DeclarationList(List<VariableDeclaration> declarations) {
        this.declarations = declarations;
    }

    public static DeclarationList fromString(String encoded) {
        return new DeclarationList(Arrays.stream(encoded.split(",")).filter(StringUtils::nonEmpty).map(VariableDeclaration::fromString).collect(Collectors.toList()));
    }

    public VariableDeclaration lookup(String identifier) {
        return this.declarations.stream().filter(d -> identifier.equals(d.getIdentifier())).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot find binding for identifier: " + identifier));
    }

    public Collection<VariableDeclaration> getDeclarations() {
        return this.declarations;
    }

    public String toString() {
        return this.declarations.stream().map(VariableDeclaration::toString).collect(Collectors.joining(","));
    }
}

