/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.wildfly.cli.BaseWildflyCLIManager;
import org.uberfire.ext.security.management.wildfly.cli.WildflyGroupFileSystemCLIManager;
import org.uberfire.ext.security.management.wildfly.filesystem.WildflyGroupFileSystemManager;
import org.uberfire.ext.security.management.wildfly.filesystem.WildflyUserFileSystemManager;

public class WildflyUserFileSystemCLIManager
extends BaseWildflyCLIManager
implements UserManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(WildflyUserFileSystemCLIManager.class);
    private WildflyUserFileSystemManager usersPropertiesManager;

    public WildflyUserFileSystemCLIManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyUserFileSystemCLIManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyUserFileSystemCLIManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    private void init(final UserSystemManager usManager) {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>(3);
            arguments.put("org.uberfire.ext.security.management.wildfly.filesystem.folder-path", this.folderPath);
            arguments.put("org.uberfire.ext.security.management.wildfly.filesystem.levels", this.levels);
            arguments.put("org.uberfire.ext.security.management.wildfly.filesystem.encoded", this.encoded);
            this.usersPropertiesManager = new WildflyUserFileSystemManager(arguments){

                @Override
                protected synchronized WildflyGroupFileSystemManager getGroupsFileSystemManager() {
                    try {
                        return ((WildflyGroupFileSystemCLIManager)usManager.groups()).groupsPropertiesManager;
                    }
                    catch (ClassCastException e) {
                        return super.getGroupsFileSystemManager();
                    }
                }
            };
        }
        catch (Exception e) {
            LOG.error("Cannot find users properties file using the configuration present in the server instance.", (Throwable)e);
        }
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.init(userSystemManager);
        this.usersPropertiesManager.initialize(userSystemManager);
    }

    public void destroy() throws Exception {
        this.usersPropertiesManager.destroy();
    }

    public void assignGroups(String username, Collection<String> groups) throws SecurityManagementException {
        this.usersPropertiesManager.assignGroups(username, groups);
    }

    public void assignRoles(String username, Collection<String> roles) throws SecurityManagementException {
        this.usersPropertiesManager.assignRoles(username, roles);
    }

    public void changePassword(String username, String newPassword) throws SecurityManagementException {
        this.usersPropertiesManager.changePassword(username, newPassword);
    }

    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        return this.usersPropertiesManager.search(request);
    }

    public User get(String identifier) throws SecurityManagementException {
        return this.usersPropertiesManager.get(identifier);
    }

    public List<User> getAll() throws SecurityManagementException {
        return this.usersPropertiesManager.getAll();
    }

    public User create(User entity) throws SecurityManagementException {
        return this.usersPropertiesManager.create(entity);
    }

    public User update(User entity) throws SecurityManagementException {
        return this.usersPropertiesManager.update(entity);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        this.usersPropertiesManager.delete(identifiers);
    }

    public UserManagerSettings getSettings() {
        return this.usersPropertiesManager.getSettings();
    }
}

