/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.impl;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemVisitor;
import org.dashbuilder.navigation.impl.NavItemImpl;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class NavGroupImpl
extends NavItemImpl
implements NavGroup {
    List<NavItem> children = new ArrayList<NavItem>();

    public NavGroupImpl() {
        this.type = NavItem.Type.GROUP;
    }

    @Override
    public List<NavItem> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<NavItem> children) {
        this.children = children;
    }

    @Override
    public void accept(NavItemVisitor visitor) {
        visitor.visitGroup(this);
        for (NavItem child : this.children) {
            child.accept(visitor);
        }
    }

    @Override
    public NavItem cloneItem() {
        NavGroupImpl clone = new NavGroupImpl();
        clone.id = this.id;
        clone.name = this.name;
        clone.parent = this.parent;
        clone.description = this.description;
        clone.modifiable = this.modifiable;
        clone.context = this.context;
        for (NavItem child : this.children) {
            NavItem childClone = child.cloneItem();
            clone.children.add(childClone);
            childClone.setParent(clone);
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(super.toString("GROUP"));
        out.append("CHILDREN=[");
        this.children.forEach(i -> out.append(i.getId()).append(" "));
        out.append("]\n");
        return out.toString();
    }
}

