/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.backend.validation.BPMNValidatorImpl;
import org.kie.workbench.common.stunner.bpmn.validation.BPMNViolation;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.rule.violations.AbstractGraphViolation;
import org.kie.workbench.common.stunner.core.service.DiagramService;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.validation.ElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNValidatorImplTest {
    private static final String BPMN_VALID = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/validation/valid.bpmn";
    private static final String BPMN_VALIDATION_ISSUES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/validation/validation_issues.bpmn";
    public static final String PROCESS_UUID = "id";
    private BPMNValidatorImpl bpmnValidador;
    @Mock
    private DiagramService diagramService;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;

    @Before
    public void setUp() {
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        this.bpmnValidador = new BPMNValidatorImpl(this.diagramService);
        this.bpmnValidador.init();
    }

    private InputStream loadStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    @Test
    public void validateSerialized() {
        Collection violations = this.bpmnValidador.validate(this.getSerializedProcess(BPMN_VALID), PROCESS_UUID);
        Assert.assertTrue((boolean)violations.isEmpty());
    }

    @Test
    public void validateWithExceptionsOnParsingXML() {
        Collection violations = this.bpmnValidador.validate("INVALID_XML", PROCESS_UUID);
        this.assertProcessException(violations);
    }

    private void assertProcessException(Collection<BPMNViolation> violations) {
        Assert.assertEquals((long)violations.size(), (long)1L);
        Assert.assertEquals((long)1L, (long)violations.stream().map(AbstractGraphViolation::getUUID).filter(PROCESS_UUID::equals).count());
    }

    @Test
    public void validateWithException() {
        Collection violations = this.bpmnValidador.validate(null, PROCESS_UUID);
        this.assertProcessException(violations);
    }

    private String getSerializedProcess(String path) {
        try {
            return IOUtils.toString((InputStream)this.loadStream(path), (String)"UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Test
    public void validateWithViolation() {
        Mockito.when((Object)this.diagramService.getRawContent(this.diagram)).thenReturn((Object)this.getSerializedProcess(BPMN_VALIDATION_ISSUES));
        this.bpmnValidador.validate(this.diagram, result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)10L, (long)result.size());
            Assert.assertTrue((boolean)result.stream().map(Violation::getViolationType).allMatch(t -> Violation.Type.WARNING.equals(t)));
            Assert.assertEquals((long)10L, (long)result.stream().map(ElementViolation::getUUID).filter(StringUtils::nonEmpty).count());
            Assert.assertEquals((long)4L, (long)result.stream().map(ElementViolation::getUUID).filter("_426E32AD-E08B-4025-B201-9850EEC82254"::equals).count());
            Assert.assertEquals((long)3L, (long)result.stream().map(ElementViolation::getUUID).filter("_3E6C197E-FF8A-41F4-AEB6-710454E8529C"::equals).count());
            Assert.assertEquals((long)1L, (long)result.stream().map(ElementViolation::getUUID).filter("_0F455E77-669C-480F-A4A2-C5070EF1A83F"::equals).count());
            Assert.assertEquals((long)2L, (long)result.stream().map(ElementViolation::getUUID).filter("_5B1068ED-1260-41FD-B7C1-226CB909E569"::equals).count());
        });
    }

    @Test
    public void validateNoViolations() {
        Mockito.when((Object)this.diagramService.getRawContent(this.diagram)).thenReturn((Object)this.getSerializedProcess(BPMN_VALID));
        this.bpmnValidador.validate(this.diagram, result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.isEmpty());
        });
    }

    @Test
    public void getDefinitionSetId() {
        Assert.assertEquals((Object)this.bpmnValidador.getDefinitionSetId(), (Object)BindableAdapterUtils.getDefinitionId(BPMNDefinitionSet.class));
    }
}

