/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQuery;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryResult;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class DefExplorerQueryServiceImpl
implements DefExplorerQueryService {
    @Inject
    private WorkspaceProjectService projectService;
    @Inject
    private DataSourceDefQueryService queryService;
    @Inject
    private KieModuleService moduleService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private User identity;

    public DefExplorerQueryResult executeQuery(DefExplorerQuery query) {
        PortablePreconditions.checkNotNull((String)"query", (Object)query);
        if (query.isGlobalQuery()) {
            DefExplorerQueryResult result = new DefExplorerQueryResult();
            result.setDataSourceDefs(this.queryService.findGlobalDataSources(true));
            result.setDriverDefs(this.queryService.findGlobalDrivers());
            return result;
        }
        return this.resolveQuery(query);
    }

    private DefExplorerQueryResult resolveQuery(DefExplorerQuery query) {
        DefExplorerQueryResult result = new DefExplorerQueryResult();
        Set<OrganizationalUnit> organizationalUnits = this.resolveOrganizationalUnits();
        result.getOrganizationalUnits().addAll(organizationalUnits);
        if (query.getOrganizationalUnit() == null || !this.containsOU(organizationalUnits, query.getOrganizationalUnit())) {
            return result;
        }
        Map<String, Repository> repositories = this.resolveRepositories(query.getOrganizationalUnit());
        result.getRepositories().addAll(repositories.values());
        if (query.getRepository() == null || !repositories.containsKey(query.getRepository().getAlias())) {
            return result;
        }
        Map<String, Module> modules = this.resolveModules(repositories, query.getBranchName());
        result.getModules().addAll(modules.values());
        if (query.getModule() == null || !modules.containsKey(query.getModule().getModuleName())) {
            return result;
        }
        result.setDataSourceDefs(this.queryService.findModuleDataSources(query.getModule()));
        result.setDriverDefs(this.queryService.findModuleDrivers(query.getModule()));
        return result;
    }

    private boolean containsOU(Collection<OrganizationalUnit> organizationalUnits, OrganizationalUnit ou) {
        for (OrganizationalUnit unit : organizationalUnits) {
            if (!unit.getName().equals(ou.getName())) continue;
            return true;
        }
        return false;
    }

    private Set<OrganizationalUnit> resolveOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    private Map<String, Repository> resolveRepositories(OrganizationalUnit organizationalUnit) {
        HashMap<String, Repository> authorizedRepositories = new HashMap<String, Repository>();
        if (organizationalUnit == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, this.identity)) continue;
            authorizedRepositories.put(repository.getAlias(), repository);
        }
        return authorizedRepositories;
    }

    private Map<String, Module> resolveModules(Map<String, Repository> repositories, String branchName) {
        HashMap<String, Module> authorizedModules = new HashMap<String, Module>();
        for (Repository repository : repositories.values()) {
            if (!this.containsBranch(repository.getBranches(), branchName)) continue;
            Module module = this.projectService.resolveProject(repository).getMainModule();
            authorizedModules.put(module.getModuleName(), module);
        }
        return authorizedModules;
    }

    private boolean containsBranch(Collection<Branch> branches, String branchName) {
        for (Branch branch : branches) {
            if (!branchName.equals(branch.getName())) continue;
            return true;
        }
        return false;
    }
}

