/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.SubProcess;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes.EventSubProcessPostConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EndEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.StartCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.UserTask;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EventSubProcessPostConverterTest {
    @Mock
    private ProcessPropertyWriter processWriter;
    @Mock
    private BasePropertyWriter nodeWriter;
    @Mock
    private Node<View<? extends BPMNViewDefinition>, Edge> eventSubprocessNode;
    @Mock
    private SubProcess subProcess;
    private List<Edge> outEdges;
    private EventSubProcessPostConverter converter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.nodeWriter.getElement()).thenReturn((Object)this.subProcess);
        this.outEdges = new ArrayList<Edge>();
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new IntermediateTimerEvent())));
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new UserTask())));
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new ScriptTask())));
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new IntermediateSignalEventThrowing())));
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new EmbeddedSubprocess())));
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new EndEscalationEvent())));
        Mockito.when((Object)this.eventSubprocessNode.getOutEdges()).thenReturn(this.outEdges);
        this.converter = new EventSubProcessPostConverter();
    }

    @Test
    public void testProcessWhenIsForCompensation() {
        this.outEdges.add(TestUtils.mockEdge((Node)Mockito.mock(Node.class), TestUtils.newNode(new StartCompensationEvent())));
        this.converter.process(this.processWriter, this.nodeWriter, this.eventSubprocessNode);
        ((SubProcess)Mockito.verify((Object)this.subProcess)).setIsForCompensation(true);
    }

    @Test
    public void testProcessWhenIsNotForCompensation() {
        this.converter.process(this.processWriter, this.nodeWriter, this.eventSubprocessNode);
        ((SubProcess)Mockito.verify((Object)this.subProcess, (VerificationMode)Mockito.never())).setIsForCompensation(true);
    }
}

