/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.workbench.common.widgets.client.menu.AboutCommand;
import org.kie.workbench.common.widgets.client.menu.AppLauncherMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.ResetPerspectivesMenuBuilder;
import org.kie.workbench.common.workbench.client.menu.WorkbenchConfigurationMenuBuilder;
import org.kie.workbench.common.workbench.client.menu.custom.AdminCustomMenuBuilder;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.menu.CustomSplashHelp;
import org.uberfire.client.menu.WorkbenchViewModeSwitcherMenuBuilder;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.menu.UserMenu;
import org.uberfire.client.workbench.widgets.menu.UtilityMenuBar;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
public class DefaultWorkbenchFeaturesMenusHelper {
    DefaultWorkbenchConstants constants = DefaultWorkbenchConstants.INSTANCE;
    protected SyncBeanManager iocManager;
    private ActivityManager activityManager;
    private PerspectiveManager perspectiveManager;
    protected Caller<AuthenticationService> authService;
    protected User identity;
    protected UserMenu userMenu;
    protected UtilityMenuBar utilityMenuBar;
    protected WorkbenchMegaMenuPresenter menuBar;
    protected AboutCommand aboutCommand;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private PlaceManager placeManager;

    public DefaultWorkbenchFeaturesMenusHelper() {
    }

    @Inject
    public DefaultWorkbenchFeaturesMenusHelper(SyncBeanManager iocManager, ActivityManager activityManager, PerspectiveManager perspectiveManager, Caller<AuthenticationService> authService, User identity, UserMenu userMenu, UtilityMenuBar utilityMenuBar, WorkbenchMegaMenuPresenter menuBar, AboutCommand aboutCommand, AuthorizationManager authorizationManager, SessionInfo sessionInfo, PlaceManager placeManager) {
        this.iocManager = iocManager;
        this.activityManager = activityManager;
        this.perspectiveManager = perspectiveManager;
        this.authService = authService;
        this.identity = identity;
        this.userMenu = userMenu;
        this.utilityMenuBar = utilityMenuBar;
        this.menuBar = menuBar;
        this.aboutCommand = aboutCommand;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.placeManager = placeManager;
    }

    public List<? extends MenuItem> getHomeViews() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>(1);
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.HomePage()).perspective(this.getDefaultPerspectiveIdentifier())).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.Admin()).perspective("AdminPagePerspective")).endMenu()).build().getItems().get(0));
        return result;
    }

    public List<MenuItem> getAuthoringViews() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>(4);
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.ProjectAuthoring()).perspective("LibraryPerspective")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.ArtifactRepository()).perspective("GuvnorM2RepoPerspective")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.Administration()).perspective("AdministrationPerspective")).endMenu()).build().getItems().get(0));
        return result;
    }

    public List<? extends MenuItem> getProcessManagementViews() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>(2);
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.ProcessDefinitions()).perspective("ProcessDefinitions")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.ProcessInstances()).perspective("ProcessInstances")).endMenu()).build().getItems().get(0));
        return result;
    }

    public List<? extends MenuItem> getExtensionsViews() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>(3);
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.Plugins()).perspective("PlugInAuthoringPerspective")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.Apps()).perspective("AppsPerspective")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.DataSets()).perspective("DataSetAuthoringPerspective")).endMenu()).build().getItems().get(0));
        result.add((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.DataSources()).perspective("DataSourceManagementPerspective")).endMenu()).build().getItems().get(0));
        return result;
    }

    public void addRolesMenuItems() {
        for (Menus roleMenus : this.getRoles()) {
            this.userMenu.addMenus(roleMenus);
        }
    }

    public void addGroupsMenuItems() {
        for (Menus groups : this.getGroups()) {
            this.userMenu.addMenus(groups);
        }
    }

    public void addWorkbenchViewModeSwitcherMenuItem() {
        this.userMenu.addMenus(((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(WorkbenchViewModeSwitcherMenuBuilder.class, new Annotation[0]).getInstance())).endMenu()).build());
    }

    public void addWorkbenchConfigurationMenuItem() {
        this.utilityMenuBar.addMenus(((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(WorkbenchConfigurationMenuBuilder.class, new Annotation[0]).getInstance())).endMenu()).build());
    }

    public void addUtilitiesMenuItems() {
        this.addUserMenuItems();
        MenuFactory.TopLevelMenusBuilder menuBuilder = (MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(AppLauncherMenuBuilder.class, new Annotation[0]).getInstance())).endMenu();
        menuBuilder.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(CustomSplashHelp.class, new Annotation[0]).getInstance()).endMenu();
        if (this.hasAccessToPerspective("AdminPagePerspective")) {
            menuBuilder.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(AdminCustomMenuBuilder.class, new Annotation[0]).getInstance()).endMenu();
        }
        menuBuilder.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.iocManager.lookupBean(ResetPerspectivesMenuBuilder.class, new Annotation[0]).getInstance()).endMenu();
        menuBuilder.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.userMenu).endMenu();
        Menus utilityMenus = menuBuilder.build();
        this.menuBar.addMenus(utilityMenus);
    }

    public void addUserMenuItems() {
        this.userMenu.clear();
        Menus userMenus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.constants.LogOut()).respondsWith((Command)new LogoutCommand())).endMenu()).newTopLevelMenu("About").respondsWith((Command)this.aboutCommand)).endMenu()).build();
        this.userMenu.addMenus(userMenus);
    }

    public String getDefaultPerspectiveIdentifier() {
        return this.perspectiveManager.getDefaultPerspectiveIdentifier();
    }

    public List<PerspectiveActivity> getPerspectiveActivities() {
        Set activities = this.activityManager.getActivities(PerspectiveActivity.class);
        ArrayList<PerspectiveActivity> sortedActivitiesForDisplay = new ArrayList<PerspectiveActivity>(activities);
        Collections.sort(sortedActivitiesForDisplay, (o1, o2) -> o1.getDefaultPerspectiveLayout().getName().compareTo(o2.getDefaultPerspectiveLayout().getName()));
        return sortedActivitiesForDisplay;
    }

    public List<MenuItem> getPerspectivesMenuItems() {
        ArrayList<MenuItem> perspectives = new ArrayList<MenuItem>();
        for (PerspectiveActivity perspective : this.getPerspectiveActivities()) {
            String name = perspective.getDefaultPerspectiveLayout().getName();
            MenuItem item = (MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)name).perspective(perspective.getIdentifier())).endMenu()).build().getItems().get(0);
            perspectives.add(item);
        }
        return perspectives;
    }

    public List<Menus> getRoles() {
        Set roles = this.identity.getRoles();
        ArrayList<Menus> result = new ArrayList<Menus>(roles.size());
        result.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)this.constants.LogOut()).respondsWith((Command)new LogoutCommand())).endMenu()).build());
        for (Role role : roles) {
            if (role.getName().equals("IS_REMEMBER_ME")) continue;
            result.add(((MenuFactory.Builder)MenuFactory.newSimpleItem((String)(this.constants.Role() + ": " + role.getName())).endMenu()).build());
        }
        return result;
    }

    public List<Menus> getGroups() {
        Set groups = this.identity.getGroups();
        ArrayList<Menus> result = new ArrayList<Menus>(groups.size());
        for (Group group : groups) {
            result.add(((MenuFactory.Builder)MenuFactory.newSimpleItem((String)(this.constants.Group() + ": " + group.getName())).endMenu()).build());
        }
        return result;
    }

    public MenuFactory.TopLevelMenusBuilder<MenuFactory.MenuBuilder> buildMenusFromNavTree(NavTree navTree) {
        if (navTree == null) {
            return null;
        }
        MenuFactory.MenuBuilder builder = null;
        for (NavItem navItem : navTree.getRootItems()) {
            NavWorkbenchCtx navCtx;
            if (navItem instanceof NavDivider || navItem instanceof NavGroup && ((NavGroup)navItem).getChildren().isEmpty()) continue;
            builder = builder == null ? MenuFactory.newTopLevelMenu((String)navItem.getName()) : ((MenuFactory.TopLevelMenusBuilder)builder.endMenu()).newTopLevelMenu(navItem.getName());
            if (navItem instanceof NavGroup) {
                List<MenuItem> childItems = this.buildMenuItemsFromNavGroup((NavGroup)navItem);
                builder.withItems(childItems);
            }
            if ((navCtx = NavWorkbenchCtx.get((NavItem)navItem)).getResourceId() == null || !ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) continue;
            PlaceRequest placeRequest = this.resolvePlaceRequest(navCtx.getResourceId());
            builder = (MenuFactory.MenuBuilder)builder.place(placeRequest);
        }
        return builder != null ? (MenuFactory.TopLevelMenusBuilder)builder.endMenu() : null;
    }

    public List<MenuItem> buildMenuItemsFromNavGroup(NavGroup navGroup) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        for (NavItem navItem : navGroup.getChildren()) {
            NavWorkbenchCtx navCtx;
            if (navItem instanceof NavDivider) continue;
            MenuFactory.MenuBuilder builder = MenuFactory.newSimpleItem((String)navItem.getName());
            if (navItem instanceof NavGroup) {
                List<MenuItem> childItems = this.buildMenuItemsFromNavGroup((NavGroup)navItem);
                builder.withItems(childItems);
            }
            if ((navCtx = NavWorkbenchCtx.get((NavItem)navItem)).getResourceId() != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
                PlaceRequest placeRequest = this.resolvePlaceRequest(navCtx.getResourceId());
                builder.place(placeRequest);
            }
            MenuItem menuItem = (MenuItem)((MenuFactory.Builder)builder.endMenu()).build().getItems().get(0);
            result.add(menuItem);
        }
        return result;
    }

    public PlaceRequest resolvePlaceRequest(String perspectiveId) {
        return new DefaultPlaceRequest(perspectiveId);
    }

    boolean hasAccessToPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.sessionInfo.getIdentity());
    }

    public static native void redirect(String var0);

    protected class LogoutCommand
    implements Command {
        protected LogoutCommand() {
        }

        public void execute() {
            DefaultWorkbenchFeaturesMenusHelper.this.perspectiveManager.savePerspectiveState(() -> DefaultWorkbenchFeaturesMenusHelper.this.placeManager.closePlace(DefaultWorkbenchFeaturesMenusHelper.this.perspectiveManager.getCurrentPerspectivePlaceRequest(), () -> this.doRedirect(this.getRedirectURL())));
        }

        void doRedirect(String url) {
            DefaultWorkbenchFeaturesMenusHelper.redirect(url);
        }

        String getRedirectURL() {
            String gwtModuleBaseURL = this.getGWTModuleBaseURL();
            String gwtModuleName = this.getGWTModuleName();
            String locale = this.getLocale();
            String url = gwtModuleBaseURL.replaceFirst("/" + gwtModuleName + "/", "/logout.jsp?locale=" + locale);
            return url;
        }

        String getGWTModuleBaseURL() {
            return GWT.getModuleBaseURL();
        }

        String getGWTModuleName() {
            return GWT.getModuleName();
        }

        String getLocale() {
            return LocaleInfo.getCurrentLocale().getLocaleName();
        }
    }
}

