/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.test;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.inject.Inject;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.workbench.client.test.TestResultDonutPresenter;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingView;

@Templated
public class TestRunnerReportingViewImpl
implements TestRunnerReportingView {
    private TestRunnerReportingView.Presenter presenter;
    @DataField
    private HTMLDivElement resultPanel;
    @DataField
    private HTMLDivElement testResultIcon;
    @DataField
    private HTMLDivElement testResultText;
    @DataField
    private HTMLDivElement scenariosRun;
    @DataField
    private HTMLDivElement completedAt;
    @DataField
    private HTMLDivElement duration;
    @DataField
    private HTMLAnchorElement viewAlerts;
    @DataField
    private HTMLDivElement donutDivContainer;
    @DataField
    private HTMLDivElement donutDiv;
    private TestResultDonutPresenter testResultDonutPresenter;
    private TranslationService translationService;

    @Inject
    public TestRunnerReportingViewImpl(HTMLDivElement resultPanel, HTMLDivElement testResultIcon, HTMLDivElement testResultText, HTMLDivElement scenariosRun, HTMLDivElement completedAt, HTMLDivElement duration, HTMLAnchorElement viewAlerts, HTMLDivElement donutDivContainer, HTMLDivElement donutDiv, TestResultDonutPresenter testResultDonutPresenter, TranslationService translationService) {
        this.resultPanel = resultPanel;
        this.testResultIcon = testResultIcon;
        this.testResultText = testResultText;
        this.scenariosRun = scenariosRun;
        this.completedAt = completedAt;
        this.duration = duration;
        this.viewAlerts = viewAlerts;
        this.donutDivContainer = donutDivContainer;
        this.donutDiv = donutDiv;
        this.testResultDonutPresenter = testResultDonutPresenter;
        this.translationService = translationService;
        testResultDonutPresenter.init(donutDiv);
    }

    @EventHandler(value={"viewAlerts"})
    public void onClickEvent(ClickEvent event) {
        this.presenter.onViewAlerts();
    }

    @Override
    public TestRunnerReportingView.Presenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void reset() {
        this.testResultIcon.className = "";
        this.testResultText.textContent = "";
        this.duration.textContent = "";
        this.completedAt.textContent = "";
        this.scenariosRun.textContent = "";
        this.resetDonut();
    }

    @Override
    public void setPresenter(TestRunnerReportingView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showSuccess() {
        this.testResultIcon.className = "pficon pficon-ok";
        this.testResultText.textContent = this.translationService.format("TestRunnerReportingViewImpl.PASSED", new Object[0]);
    }

    @Override
    public void showFailure() {
        this.testResultIcon.className = "pficon pficon-error-circle-o";
        this.testResultText.textContent = this.translationService.format("TestRunnerReportingViewImpl.FAILED", new Object[0]);
    }

    @Override
    public void setRunStatus(String completedAt, String scenariosRun, String duration) {
        this.completedAt.textContent = completedAt;
        this.scenariosRun.textContent = scenariosRun;
        this.duration.textContent = duration;
    }

    @Override
    public void resetDonut() {
        this.donutDivContainer.hidden = true;
    }

    @Override
    public void showSuccessFailureDiagram(int passed, int failed) {
        this.donutDivContainer.hidden = false;
        this.testResultDonutPresenter.showSuccessFailureDiagram(passed, failed);
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.resultPanel);
    }
}

