/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.DefinitionSet;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendDefinitionSetAdapter<T>
extends AbstractReflectDefinitionSetAdapter<T>
implements DefinitionSetAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendDefinitionSetAdapter.class);
    private final BackendDefinitionAdapter annotatedDefinitionAdapter;

    @Inject
    public BackendDefinitionSetAdapter(BackendDefinitionAdapter annotatedDefinitionAdapter) {
        this.annotatedDefinitionAdapter = annotatedDefinitionAdapter;
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(DefinitionSet.class) != null;
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T definitionSet) {
        DefinitionSet annotation;
        Class result = null;
        if (null != definitionSet && null != (annotation = definitionSet.getClass().getAnnotation(DefinitionSet.class))) {
            result = annotation.graphFactory();
        }
        return result;
    }

    public Annotation getQualifier(T definitionSet) {
        DefinitionSet annotation;
        if (null != definitionSet && null != (annotation = definitionSet.getClass().getAnnotation(DefinitionSet.class))) {
            return () -> ((DefinitionSet)annotation).qualifier();
        }
        return null;
    }

    public String getDescription(T definitionSet) {
        try {
            return (String)this.getAnnotatedFieldValue(definitionSet, Description.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for DefinitionSet with id " + this.getId(definitionSet));
            return BindableAdapterUtils.toSimpleName(definitionSet);
        }
    }

    public Set<String> getDefinitions(T definitionSet) {
        return this.getAnnotatedDefinitions(definitionSet);
    }
}

