/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.kie.workbench.common.stunner.core.backend.service.BackendFileSystemManager;

public class URLUtils {
    public static byte[] readBytesFromURL(String uri) throws IOException {
        return URLUtils.readBytes(new URL(uri).openStream());
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String readFromURL(String uri) throws IOException {
        return URLUtils.readFromURL(new URL(uri));
    }

    public static String readFromURL(URL url) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), BackendFileSystemManager.UT8));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
    }

    public static String buildDataURIFromURL(String url) throws Exception {
        return URLUtils.buildDataURIFromURL(new URL(url));
    }

    public static String buildDataURIFromURL(URL url) throws Exception {
        return URLUtils.buildDataURIFromStream(url.getFile(), url.openStream());
    }

    public static String buildDataURIFromStream(String fileName, InputStream inputStream) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String contentType = URLUtils.guessContentType(fileName, inputStream);
        if (null != contentType) {
            int bytesRead;
            byte[] chunk = new byte[4096];
            while ((bytesRead = inputStream.read(chunk)) > 0) {
                os.write(chunk, 0, bytesRead);
            }
            os.flush();
            inputStream.close();
            return "data:" + contentType + ";base64," + Base64.getEncoder().encodeToString(os.toByteArray());
        }
        throw new UnsupportedOperationException("Content type is undefined.");
    }

    public static String guessContentType(String fileName, InputStream stream) throws Exception {
        String contentType = URLConnection.guessContentTypeFromStream(stream);
        if (null == contentType) {
            int index = fileName.lastIndexOf(".");
            return index >= 0 ? "image/" + fileName.substring(index + 1, fileName.length()) : null;
        }
        return contentType;
    }
}

