/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class BranchUtil {
    private BranchUtil() {
    }

    public static void deleteUnfilteredBranches(Repository repository, List<String> branchesToKeep) throws GitAPIException {
        if (branchesToKeep == null || branchesToKeep.isEmpty()) {
            return;
        }
        org.eclipse.jgit.api.Git git = org.eclipse.jgit.api.Git.wrap((Repository)repository);
        String[] toDelete = (String[])git.branchList().call().stream().map(Ref::getName).map(fullname -> fullname.substring(fullname.lastIndexOf(47) + 1)).filter(name -> !branchesToKeep.contains(name)).toArray(String[]::new);
        git.branchDelete().setBranchNames(toDelete).setForce(true).call();
    }

    public static void existsBranch(Git git, String branch) {
        if (git.getRef(branch) == null) {
            throw new GitException(String.format("Branch <<%s>> does not exist", branch));
        }
    }
}

