/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.data.Triple;

public class UserExplorerData {
    private Map<String, Object> content = new HashMap<String, Object>();
    private Map<String, Set<String>> repositoryKeys = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> moduleKeys = new HashMap<String, Set<String>>();

    public Repository get(OrganizationalUnit organizationalUnit) {
        if (organizationalUnit == null) {
            return null;
        }
        Object obj = this.content.get(organizationalUnit.getName());
        if (obj != null && obj instanceof Repository) {
            return (Repository)obj;
        }
        return null;
    }

    public Module get(OrganizationalUnit organizationalUnit, Repository repository) {
        if (organizationalUnit == null || repository == null || !repository.getDefaultBranch().isPresent()) {
            return null;
        }
        Object obj = this.content.get(Pair.newPair((Object)organizationalUnit.getName(), (Object)((Branch)repository.getDefaultBranch().get()).getPath()).toString());
        if (obj != null && obj instanceof Module) {
            return (Module)obj;
        }
        return null;
    }

    public FolderItem getFolderItem(WorkspaceProject project, Module module) {
        if (project.getOrganizationalUnit() == null || project.getRepository() == null || module == null) {
            return null;
        }
        Object obj = this.content.get(new FolderItemKey(project.getOrganizationalUnit().getName(), project.getBranch().getPath(), module.getPomXMLPath().toURI()).toString());
        if (obj != null && obj instanceof FolderItem) {
            return (FolderItem)obj;
        }
        return null;
    }

    public Package getPackage(WorkspaceProject project, Module module) {
        if (project.getRepository() == null || module == null) {
            return null;
        }
        Object obj = this.content.get(new PackageKey(project.getOrganizationalUnit().getName(), project.getBranch().getPath(), module.getPomXMLPath().toURI()).toString());
        if (obj != null && obj instanceof Package) {
            return (Package)obj;
        }
        return null;
    }

    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        this.content.put(organizationalUnit.getName(), repository);
    }

    public void addModule(OrganizationalUnit organizationalUnit, Repository repository, Module module) {
        if (repository.getDefaultBranch().isPresent()) {
            String key = Pair.newPair((Object)organizationalUnit.getName(), (Object)((Branch)repository.getDefaultBranch().get()).getPath()).toString();
            this.content.put(key, module);
            this.indexRepository(repository, key);
        }
    }

    public void addFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Module module, FolderItem item) {
        if (repository.getDefaultBranch().isPresent()) {
            String key = new FolderItemKey(organizationalUnit.getName(), ((Branch)repository.getDefaultBranch().get()).getPath(), module.getPomXMLPath().toURI()).toString();
            this.content.put(key, item);
            this.indexRepository(repository, key);
            this.indexModule(module, key);
        }
    }

    public void addPackage(OrganizationalUnit organizationalUnit, Repository repository, Module module, Package pkg) {
        if (repository.getDefaultBranch().isPresent()) {
            String key = new PackageKey(organizationalUnit.getName(), ((Branch)repository.getDefaultBranch().get()).getPath(), module.getPomXMLPath().toURI()).toString();
            this.content.put(key, pkg);
            this.indexRepository(repository, key);
            this.indexModule(module, key);
        }
    }

    private void indexRepository(Repository repository, String key) {
        if (!this.repositoryKeys.containsKey(repository.getUri())) {
            this.repositoryKeys.put(repository.getUri(), new HashSet());
        }
        this.repositoryKeys.get(repository.getUri()).add(key);
    }

    private void indexModule(Module module, String key) {
        String moduleRef = module.getPomXMLPath().toURI();
        if (!this.moduleKeys.containsKey(moduleRef)) {
            this.moduleKeys.put(moduleRef, new HashSet());
        }
        this.moduleKeys.get(moduleRef).add(key);
    }

    public boolean deleteModule(Module module) {
        boolean changed = false;
        String moduleRef = module.getPomXMLPath().toURI();
        if (this.moduleKeys.containsKey(moduleRef)) {
            changed = true;
            for (String key2Delete : this.moduleKeys.get(moduleRef)) {
                this.content.remove(key2Delete);
            }
        }
        return changed;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    private static class PackageKey
    extends Triple<String, String, String> {
        public PackageKey(String name, Path root, String s3) {
            super((Object)name, (Object)root.toURI(), (Object)s3);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageKey)) {
                return false;
            }
            return super.equals(o);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + PackageKey.class.hashCode();
            return result;
        }
    }

    private static class FolderItemKey
    extends Triple<String, String, String> {
        public FolderItemKey(String name, Path root, String s3) {
            super((Object)name, (Object)root.toURI(), (Object)s3);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof FolderItemKey)) {
                return false;
            }
            return super.equals(o);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + FolderItemKey.class.hashCode();
            return result;
        }
    }
}

