/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.registry.rule.RuleHandlerRegistry;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleManagerImpl;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;

@Dependent
@Typed(value={CachedRuleManager.class})
public class CachedRuleManager
implements RuleManager {
    private final RuleManagerImpl ruleManager;
    private final Map<String, CachedContextRules> cachedContextRules;

    @Inject
    public CachedRuleManager(RuleManagerImpl ruleManager) {
        this.ruleManager = ruleManager;
        this.cachedContextRules = new HashMap<String, CachedContextRules>(4);
    }

    @PostConstruct
    public void init() {
        this.ruleManager.setRulesProvider(this::getRulesByContext).setRuleEvaluator(new RuleManagerImpl.DefaultRuleEvaluator(){

            @Override
            public boolean accepts(RuleEvaluationHandler handler, Rule rule) {
                return true;
            }
        });
    }

    public RuleHandlerRegistry registry() {
        return this.ruleManager.registry();
    }

    public RuleViolations evaluate(RuleSet ruleSet, RuleEvaluationContext context) {
        return this.ruleManager.evaluate(ruleSet, context);
    }

    @PreDestroy
    public void destroy() {
        this.cachedContextRules.values().forEach(CachedContextRules::clear);
        this.cachedContextRules.clear();
    }

    private Collection<Rule> getRulesByContext(RuleSet ruleSet, RuleEvaluationContext context) {
        CachedContextRules crs = this.cachedContextRules.get(ruleSet.getName());
        if (null == crs) {
            crs = new CachedContextRules();
            this.cachedContextRules.put(ruleSet.getName(), crs);
        }
        return crs.getRulesByContext(ruleSet, context);
    }

    private class CachedContextRules {
        private final Map<Class<? extends RuleEvaluationContext>, List<Rule>> rulesByContent = new HashMap<Class<? extends RuleEvaluationContext>, List<Rule>>(15);

        public Collection<Rule> getRulesByContext(RuleSet ruleSet, RuleEvaluationContext context) {
            List<Rule> rules = this.rulesByContent.get(context.getClass());
            if (null == rules) {
                return this.cacheRulesByContext(ruleSet, context);
            }
            return rules;
        }

        public Collection<Rule> cacheRulesByContext(RuleSet ruleSet, RuleEvaluationContext context) {
            Collection handlers = CachedRuleManager.this.registry().getHandlersByContext(context.getType());
            List<Rule> rules = ruleSet.getRules().stream().filter(rule -> this.accepts(handlers, (Rule)rule)).collect(Collectors.toList());
            this.rulesByContent.put(context.getClass(), rules);
            return rules;
        }

        public void clear() {
            this.rulesByContent.clear();
        }

        private boolean accepts(Collection<RuleEvaluationHandler> handlers, Rule rule) {
            return RuleManagerImpl.isRuleExtension().test(rule) || handlers.stream().anyMatch(handler -> RuleManagerImpl.isRuleTypeAllowed().test(rule, (RuleEvaluationHandler)handler));
        }
    }
}

