/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.ConfigBasedPipeline;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.SystemPipelineDescriptor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskManager;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskDefImpl;
import org.guvnor.ala.registry.PipelineRegistry;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.exceptions.BusinessException;

@ApplicationScoped
public class RestPipelineServiceImpl
implements PipelineService {
    private PipelineExecutorTaskManager executorTaskManager;
    private PipelineRegistry pipelineRegistry;
    private RuntimeRegistry runtimeRegistry;

    public RestPipelineServiceImpl() {
    }

    @Inject
    public RestPipelineServiceImpl(PipelineExecutorTaskManager executorTaskManager, PipelineRegistry pipelineRegistry, RuntimeRegistry runtimeRegistry, @Any Instance<SystemPipelineDescriptor> pipelineDescriptorInstance) {
        this.executorTaskManager = executorTaskManager;
        this.pipelineRegistry = pipelineRegistry;
        this.runtimeRegistry = runtimeRegistry;
        this.registerPipelines(pipelineDescriptorInstance.iterator());
    }

    private void registerPipelines(Iterator<SystemPipelineDescriptor> iterator) {
        iterator.forEachRemaining(pipelineDescriptor -> {
            if (pipelineDescriptor.getProviderType().isPresent()) {
                this.pipelineRegistry.registerPipeline(pipelineDescriptor.getPipeline(), (ProviderType)pipelineDescriptor.getProviderType().get());
            } else {
                this.pipelineRegistry.registerPipeline(pipelineDescriptor.getPipeline());
            }
        });
    }

    public PipelineConfigsList getPipelineConfigs(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        List configs = this.pipelineRegistry.getPipelines(page.intValue(), pageSize.intValue(), sort, sortOrder).stream().filter(p -> p instanceof ConfigBasedPipeline).map(p -> ((ConfigBasedPipeline)p).getConfig()).collect(Collectors.toList());
        return new PipelineConfigsList(configs);
    }

    public PipelineConfigsList getPipelineConfigs(String providerTypeName, String providerTypeVersion, Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        List configs = this.pipelineRegistry.getPipelines(providerTypeName, providerTypeVersion, page.intValue(), pageSize.intValue(), sort, sortOrder).stream().filter(p -> p instanceof ConfigBasedPipeline).map(p -> ((ConfigBasedPipeline)p).getConfig()).collect(Collectors.toList());
        return new PipelineConfigsList(configs);
    }

    public List<String> getPipelineNames(String providerTypeName, String providerTypeVersion, Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return this.pipelineRegistry.getPipelines(providerTypeName, providerTypeVersion, page.intValue(), pageSize.intValue(), sort, sortOrder).stream().map(Pipeline::getName).collect(Collectors.toList());
    }

    public String newPipeline(PipelineConfig config) throws BusinessException {
        ConfigBasedPipeline pipeline = PipelineFactory.newPipeline((PipelineConfig)config);
        this.pipelineRegistry.registerPipeline((Pipeline)pipeline);
        return config.getName();
    }

    public String newPipeline(PipelineConfig config, ProviderType providerType) throws BusinessException {
        ConfigBasedPipeline pipeline = PipelineFactory.newPipeline((PipelineConfig)config);
        this.pipelineRegistry.registerPipeline((Pipeline)pipeline, providerType);
        return config.getName();
    }

    public String runPipeline(String pipelineId, Input input, boolean async) throws BusinessException {
        Pipeline pipeline = this.pipelineRegistry.getPipelineByName(pipelineId);
        if (pipeline == null) {
            throw new BusinessException("Pipeline: " + pipelineId + " was not found.");
        }
        String providerName = (String)input.get((Object)"provider-name");
        Provider provider = null;
        ProviderType providerType = null;
        if (providerName != null && !providerName.isEmpty()) {
            provider = this.runtimeRegistry.getProvider(providerName);
        }
        if (provider == null) {
            providerType = this.pipelineRegistry.getProviderType(pipelineId);
        }
        PipelineExecutorTaskDefImpl taskDef = provider != null ? new PipelineExecutorTaskDefImpl(pipeline, input, (ProviderId)provider) : (providerType != null ? new PipelineExecutorTaskDefImpl(pipeline, input, providerType) : new PipelineExecutorTaskDefImpl(pipeline, input));
        return this.executorTaskManager.execute((PipelineExecutorTaskDef)taskDef, async ? PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS : PipelineExecutorTaskManager.ExecutionMode.SYNCHRONOUS);
    }

    public void stopPipelineExecution(String executionId) throws BusinessException {
        try {
            this.executorTaskManager.stop(executionId);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePipelineExecution(String executionId) throws BusinessException {
        try {
            this.executorTaskManager.delete(executionId);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }
}

