/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class CherryPick {
    private final Git git;
    private final String targetBranch;
    private final String[] commits;

    public CherryPick(Git git, String targetBranch, String ... commits) {
        this.git = git;
        this.targetBranch = targetBranch;
        this.commits = commits;
    }

    public void execute() {
        List<ObjectId> commits = this.git.resolveObjectIds(this.commits);
        if (commits.size() != this.commits.length) {
            throw new IOException("Couldn't resolve some commits.");
        }
        Ref headRef = this.git.getRef(this.targetBranch);
        if (headRef == null) {
            throw new IOException("Branch not found.");
        }
        try {
            for (ObjectId src : commits) {
                RevCommit srcCommit = this.git.resolveRevCommit(src);
                if (srcCommit.getParentCount() != 1) {
                    throw new IOException((Exception)new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount())));
                }
                this.git.refUpdate(this.targetBranch, srcCommit);
            }
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)((Object)new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), (Throwable)e)));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

