/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.json;

import java.util.List;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;

public class NavTreeJSONMarshaller {
    private static final String NAV_ITEM_ID = "id";
    private static final String NAV_ITEM_TYPE = "type";
    private static final String NAV_ITEM_NAME = "name";
    private static final String NAV_ITEM_DESC = "description";
    private static final String NAV_ITEM_MODIF = "modifiable";
    private static final String NAV_ITEM_CTX = "context";
    private static final String NAV_TREE_ROOT_ITEMS = "root_items";
    private static final String NAV_GROUP_CHILDREN = "children";
    private static NavTreeJSONMarshaller SINGLETON = new NavTreeJSONMarshaller();

    public static NavTreeJSONMarshaller get() {
        return SINGLETON;
    }

    public JsonObject toJson(NavTree navTree) throws JsonException {
        JsonObject json = Json.createObject();
        if (navTree != null) {
            json.put(NAV_TREE_ROOT_ITEMS, (JsonValue)this.toJson(navTree.getRootItems()));
        }
        return json;
    }

    public JsonObject toJson(NavItem navItem) throws JsonException {
        JsonObject json = Json.createObject();
        if (navItem != null) {
            json.put(NAV_ITEM_ID, navItem.getId());
            json.put(NAV_ITEM_TYPE, navItem.getType().toString());
            if (navItem.getType() != NavItem.Type.DIVIDER) {
                json.put(NAV_ITEM_NAME, navItem.getName());
                json.put(NAV_ITEM_DESC, navItem.getDescription());
                json.put(NAV_ITEM_MODIF, navItem.isModifiable());
                json.put(NAV_ITEM_CTX, navItem.getContext());
                if (navItem.getType() == NavItem.Type.GROUP) {
                    json.put(NAV_GROUP_CHILDREN, (JsonValue)this.toJson(((NavGroup)navItem).getChildren()));
                }
            }
        }
        return json;
    }

    public JsonArray toJson(List<NavItem> navItemList) throws JsonException {
        JsonArray json = Json.createArray();
        if (navItemList != null) {
            for (int i = 0; i < navItemList.size(); ++i) {
                NavItem navItem = navItemList.get(i);
                json.set(i, (JsonValue)this.toJson(navItem));
            }
        }
        return json;
    }

    public NavTree fromJson(String jsonString) throws JsonException {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        JsonObject json = Json.parse((String)jsonString);
        return this.fromJson(json);
    }

    public NavTree fromJson(JsonObject json) throws JsonException {
        if (json == null) {
            return null;
        }
        NavTree navTree = NavFactory.get().createNavTree();
        for (int i = 0; i < json.size(); ++i) {
            JsonArray rootItemArray = json.getArray(NAV_TREE_ROOT_ITEMS);
            this.parseNavItemArray(rootItemArray, navTree.getRootItems(), null);
        }
        return navTree;
    }

    private void parseNavItemArray(JsonArray json, List<NavItem> targetList, NavGroup parent) throws JsonException {
        if (json != null) {
            for (int i = 0; i < json.length(); ++i) {
                NavItem navItem = this.parseNavItem(json.getObject(i));
                if (navItem == null) continue;
                navItem.setParent(parent);
                targetList.add(navItem);
            }
        }
    }

    private NavItem parseNavItem(JsonObject json) throws JsonException {
        if (json == null) {
            return null;
        }
        NavItem navItem = null;
        String type = json.getString(NAV_ITEM_TYPE);
        if (type == null) {
            throw new RuntimeException("Nav item type not specified");
        }
        navItem = NavItem.Type.DIVIDER.toString().equals(type) ? NavFactory.get().createDivider() : (NavItem.Type.GROUP.toString().equals(type) ? NavFactory.get().createNavGroup() : NavFactory.get().createNavItem());
        String id = json.getString(NAV_ITEM_ID);
        String name = json.getString(NAV_ITEM_NAME);
        String desc = json.getString(NAV_ITEM_DESC);
        String modif = json.getString(NAV_ITEM_MODIF);
        String ctx = json.getString(NAV_ITEM_CTX);
        navItem.setId(id);
        navItem.setName(name);
        navItem.setDescription(desc);
        navItem.setModifiable(modif != null ? Boolean.parseBoolean(modif) : true);
        navItem.setContext(ctx);
        if (NavItem.Type.GROUP.toString().equals(type)) {
            JsonArray childrenArray = json.getArray(NAV_GROUP_CHILDREN);
            NavGroup navGroup = (NavGroup)navItem;
            this.parseNavItemArray(childrenArray, navGroup.getChildren(), navGroup);
        }
        return navItem;
    }
}

