/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.InputAssignmentReader;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputAssignmentReaderTest {
    public static final String ID = "PARENT_ID";

    @Test
    public void urlEncodeConstants() throws UnsupportedEncodingException {
        String decoded = "<<<#!!!#>>>";
        String expected = URLEncoder.encode("<<<#!!!#>>>", "UTF-8");
        Assignment assignment = this.createAssignment("<<<#!!!#>>>");
        InputAssignmentReader iar = new InputAssignmentReader(assignment, ID);
        AssociationDeclaration associationDeclaration = iar.getAssociationDeclaration();
        Assert.assertEquals((Object)AssociationDeclaration.Type.FromTo, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)expected, (Object)associationDeclaration.getSource());
    }

    private Assignment createAssignment(String decodedBody) {
        Assignment assignment = Factories.bpmn2.createAssignment();
        FormalExpression from = Factories.bpmn2.createFormalExpression();
        from.setBody(decodedBody);
        FormalExpression to = Factories.bpmn2.createFormalExpression();
        to.setBody(ID);
        assignment.setFrom((Expression)from);
        assignment.setTo((Expression)to);
        return assignment;
    }

    @Test
    public void testNullBody() {
        Assignment assignment = this.createAssignment(null);
        InputAssignmentReader iar = new InputAssignmentReader(assignment, ID);
        AssociationDeclaration associationDeclaration = iar.getAssociationDeclaration();
        Assert.assertEquals((Object)AssociationDeclaration.Type.FromTo, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)"", (Object)associationDeclaration.getSource());
    }
}

