/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.service.DiagramService;
import org.kie.workbench.common.stunner.core.util.XMLDisplayerData;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Service
public class DelegateDiagramService
implements DiagramService {
    private final ProjectDiagramService projectDiagramService;

    @Inject
    public DelegateDiagramService(ProjectDiagramService projectDiagramService) {
        this.projectDiagramService = projectDiagramService;
    }

    private Diagram convert(ProjectDiagram projectDiagram) {
        DiagramImpl diagram = new DiagramImpl(projectDiagram.getName(), projectDiagram.getMetadata());
        diagram.setGraph(projectDiagram.getGraph());
        return diagram;
    }

    private ProjectDiagram convert(Diagram<Graph, Metadata> diagram) {
        if (!ProjectMetadata.class.isInstance(diagram.getMetadata())) {
            throw new IllegalStateException("The Metadata is supposed to be a ProjectMetadata for diagram " + diagram.getName());
        }
        return new ProjectDiagramImpl(diagram.getName(), diagram.getGraph(), (ProjectMetadata)ProjectMetadata.class.cast(diagram.getMetadata()));
    }

    public Diagram<Graph, Metadata> getDiagramByPath(Path path) {
        return this.convert((ProjectDiagram)this.projectDiagramService.getDiagramByPath(path));
    }

    public boolean accepts(Path path) {
        return this.projectDiagramService.accepts(path);
    }

    public Path create(Path path, String name, String defSetId) {
        return this.projectDiagramService.create(path, name, defSetId);
    }

    public Metadata saveOrUpdate(Diagram<Graph, Metadata> diagram) {
        return this.projectDiagramService.saveOrUpdate((Diagram)this.convert(diagram));
    }

    public boolean delete(Diagram<Graph, Metadata> diagram) {
        return this.projectDiagramService.delete((Diagram)this.convert(diagram));
    }

    public String getRawContent(Diagram<Graph, Metadata> diagram) {
        return this.projectDiagramService.getRawContent((Diagram)this.convert(diagram));
    }

    public XMLDisplayerData getXMLFileContent(Path path) {
        return this.projectDiagramService.getXMLFileContent(path);
    }

    public Path saveOrUpdateSvg(Path diagramPath, String rawDiagramSvg) {
        return this.projectDiagramService.saveOrUpdateSvg(diagramPath, rawDiagramSvg);
    }
}

