/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.data.modeller.service.impl;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.service.shared.ModelFinderService;
import org.kie.workbench.common.forms.editor.backend.service.impl.AbstractFormModelHandler;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandler;
import org.kie.workbench.common.forms.editor.service.backend.SourceFormModelNotFoundException;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DataObjectFormModelHandler
extends AbstractFormModelHandler<DataObjectFormModel> {
    private static final String SHORT_KEY = "DataObjectFormModelHandler.shortMessage";
    private static final String FULL_KEY = "DataObjectFormModelHandler.fullMessage";
    private static final String DATA_OBJECT_KEY = "DataObjectFormModelHandler.dataObject";
    private static final Logger logger = LoggerFactory.getLogger(DataObjectFormModelHandler.class);
    private ModelFinderService finderService;
    private DataObjectFormModel updatedFormModel;
    protected FieldManager fieldManager;

    @Inject
    public DataObjectFormModelHandler(KieModuleService moduleService, ModuleClassLoaderHelper classLoaderHelper, ModelFinderService finderService, FieldManager fieldManager) {
        super(moduleService, classLoaderHelper);
        this.fieldManager = fieldManager;
        this.finderService = finderService;
    }

    public Class<DataObjectFormModel> getModelType() {
        return DataObjectFormModel.class;
    }

    protected void initialize() {
        this.checkInitialized();
        this.updatedFormModel = this.finderService.getModel(((DataObjectFormModel)this.formModel).getClassName(), this.path);
    }

    public void checkSourceModel() throws SourceFormModelNotFoundException {
        this.checkInitialized();
        if (this.updatedFormModel == null) {
            String[] params = new String[]{((DataObjectFormModel)this.formModel).getClassName()};
            throw new SourceFormModelNotFoundException(SHORT_KEY, params, FULL_KEY, params, DATA_OBJECT_KEY, this.formModel);
        }
    }

    protected void log(String message, Exception e) {
        logger.warn(message, (Throwable)e);
    }

    protected List<ModelProperty> getCurrentModelProperties() {
        return this.updatedFormModel.getProperties();
    }

    public FormModelHandler<DataObjectFormModel> newInstance() {
        return new DataObjectFormModelHandler(this.moduleService, this.classLoaderHelper, this.finderService, this.fieldManager);
    }
}

