/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemUtils;

@ApplicationScoped
@Startup
public class LockClientNotifier {
    @Inject
    @Named(value="systemFS")
    private FileSystem fs;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    private Event<LockInfo> lockEvent;
    private WatchService ws;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private volatile boolean active = true;

    @PostConstruct
    private void init() {
        if (FileSystemUtils.isGitDefaultFileSystem()) {
            this.ws = this.fs.newWatchService();
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    LockClientNotifier.this.observeAndNotifyClients();
                }
            });
        }
    }

    @PreDestroy
    private void shutdown() {
        this.executorService.shutdown();
        this.active = false;
        if (this.ws != null) {
            this.ws.close();
        }
    }

    private void observeAndNotifyClients() {
        while (this.active) {
            try {
                WatchKey wk;
                try {
                    wk = this.ws.take();
                }
                catch (Exception ex) {
                    break;
                }
                List events = wk.pollEvents();
                for (WatchEvent event : events) {
                    boolean created = event.kind().equals(StandardWatchEventKind.ENTRY_CREATE);
                    boolean deleted = event.kind().equals(StandardWatchEventKind.ENTRY_DELETE);
                    WatchContext context = (WatchContext)event.context();
                    Path path = created ? context.getPath() : context.getOldPath();
                    if (path == null || !path.getFileName().toString().endsWith(".ulock")) continue;
                    org.uberfire.backend.vfs.Path vfsLockPath = Paths.convert(path);
                    org.uberfire.backend.vfs.Path vfsPath = PathFactory.fromLock((org.uberfire.backend.vfs.Path)vfsLockPath);
                    if (created) {
                        String lockedBy = this.ioService.readAllString(path);
                        this.lockEvent.fire((Object)new LockInfo(true, lockedBy, vfsPath, vfsLockPath));
                        continue;
                    }
                    if (!deleted) continue;
                    this.lockEvent.fire((Object)new LockInfo(false, null, vfsPath, vfsLockPath));
                }
                if (wk.reset()) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
    }
}

