/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;

public class ScenarioCsvDownloadReport {
    protected static final String[] DMN_OVERALL_STATS_HEADER = new String[]{"AVAILABLE DECISIONS", "DECISIONS FIRED", "PERCENTAGE OF DECISIONS FIRED"};
    protected static final String[] RULE_OVERALL_STATS_HEADER = new String[]{"AVAILABLE RULES", "RULES FIRED", "PERCENTAGE OF RULES FIRED"};
    protected static final String[] DMN_COUNTER_HEADER = new String[]{"DECISION", "NUMBER OF TIMES"};
    protected static final String[] RULE_COUNTER_HEADER = new String[]{"RULE", "NUMBER OF TIMES"};
    protected static final String[] DMN_AUDIT_HEADER = new String[]{"TEST SCENARIO INDEX", "TEST SCENARIO NAME", "DECISION INDEX", "EVALUATED DECISION", "DECISION STATUS", "MESSAGE"};
    protected static final String[] RULE_AUDIT_HEADER = new String[]{"TEST SCENARIO INDEX", "TEST SCENARIO NAME", "RULE INDEX", "FIRED RULE", "RULE STATUS", "MESSAGE"};

    public String getReport(SimulationRunMetadata simulationRunMetadata, ScenarioSimulationModel.Type modelType) {
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT.withNullString(""));){
            List auditLogLines;
            this.generateOverallStatsHeader(printer, modelType);
            this.printOverallStatsLine(printer, simulationRunMetadata.getAvailable(), simulationRunMetadata.getExecuted(), simulationRunMetadata.getCoveragePercentage());
            Map outputCounter = simulationRunMetadata.getOutputCounter();
            if (outputCounter != null && !outputCounter.isEmpty()) {
                printer.println();
                this.generateRulesCounterHeader(printer, modelType);
                for (Map.Entry entry : outputCounter.entrySet()) {
                    this.printRulesCounterLine(printer, (String)entry.getKey(), (Integer)entry.getValue());
                }
            }
            if ((auditLogLines = simulationRunMetadata.getAuditLog().getAuditLogLines()) != null && !auditLogLines.isEmpty()) {
                printer.println();
                this.generateAuditLogHeader(printer, modelType);
                for (AuditLogLine auditLogLine : auditLogLines) {
                    this.printAuditLogLine(auditLogLine, printer);
                }
            }
        }
        catch (IOException e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return stringBuilder.toString();
    }

    protected void generateOverallStatsHeader(CSVPrinter printer, ScenarioSimulationModel.Type modelType) throws IOException {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)modelType)) {
            printer.printRecord((Object[])DMN_OVERALL_STATS_HEADER);
        } else {
            printer.printRecord((Object[])RULE_OVERALL_STATS_HEADER);
        }
    }

    protected void printOverallStatsLine(CSVPrinter printer, int available, int executed, double coveragePercentage) throws IOException {
        printer.printRecord(Arrays.asList(available, executed, coveragePercentage));
    }

    protected void generateRulesCounterHeader(CSVPrinter printer, ScenarioSimulationModel.Type modelType) throws IOException {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)modelType)) {
            printer.printRecord((Object[])DMN_COUNTER_HEADER);
        } else {
            printer.printRecord((Object[])RULE_COUNTER_HEADER);
        }
    }

    protected void printRulesCounterLine(CSVPrinter printer, String rule, int times) throws IOException {
        printer.printRecord(Arrays.asList(rule, times));
    }

    protected void generateAuditLogHeader(CSVPrinter printer, ScenarioSimulationModel.Type modelType) throws IOException {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)modelType)) {
            printer.printRecord((Object[])DMN_AUDIT_HEADER);
        } else {
            printer.printRecord((Object[])RULE_AUDIT_HEADER);
        }
    }

    protected void printAuditLogLine(AuditLogLine toPrint, CSVPrinter printer) throws IOException {
        printer.print((Object)toPrint.getScenarioIndex());
        printer.print((Object)toPrint.getScenario());
        printer.print((Object)toPrint.getExecutionIndex());
        printer.print((Object)toPrint.getDecisionOrRuleName());
        printer.print((Object)toPrint.getResult());
        printer.print((Object)toPrint.getMessage().orElse(""));
        printer.println();
    }
}

