/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.htmleditor;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.EditorTitle;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorLibraryLoader;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorPickerDialog;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorUtils;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Dependent
@Templated
public class HtmlEditorView
implements HtmlEditorPresenter.View,
IsElement {
    public static final int HTML_EDITOR_MARGIN = 14;
    @Inject
    @DataField(value="container")
    Div container;
    @Inject
    @DataField(value="html-editor")
    Div htmlEditor;
    @Inject
    @DataField(value="html-editor-toolbar")
    Div toolbar;
    @Inject
    @DataField(value="bold-action")
    Button boldAction;
    @Inject
    @DataField(value="italic-action")
    Button italicAction;
    @Inject
    @DataField(value="underline-action")
    Button underlineAction;
    @Inject
    @DataField(value="create-link-action")
    Button createLinkAction;
    @Inject
    @DataField(value="remove-link-action")
    Button removeLinkAction;
    @Inject
    @DataField(value="insert-image-action")
    Button insertImageAction;
    @Inject
    @DataField(value="insert-table-action")
    Button insertTableAction;
    @Inject
    @DataField(value="big-title-action")
    Button bigTitleAction;
    @Inject
    @DataField(value="medium-title-action")
    Button mediumTitleAction;
    @Inject
    @DataField(value="small-title-action")
    Button smallTitleAction;
    @Inject
    @DataField(value="paragraph-action")
    Button paragraphAction;
    @Inject
    @DataField(value="pre-action")
    Button preAction;
    @Inject
    @DataField(value="plain-text-action")
    Button plainTextAction;
    @Inject
    @DataField(value="quote-action")
    Button quoteAction;
    @Inject
    @DataField(value="code-action")
    Button codeAction;
    @Inject
    @DataField(value="font-size-action")
    Button fontSizeAction;
    @Inject
    @DataField(value="font-size-action-x-small")
    Anchor fontSizeActionXSmall;
    @Inject
    @DataField(value="font-size-action-small")
    Anchor fontSizeActionSmall;
    @Inject
    @DataField(value="font-size-action-medium")
    Anchor fontSizeActionMedium;
    @Inject
    @DataField(value="font-size-action-large")
    Anchor fontSizeActionLarge;
    @Inject
    @DataField(value="font-size-action-x-large")
    Anchor fontSizeActionXLarge;
    @Inject
    @DataField(value="font-size-action-xx-large")
    Anchor fontSizeActionXXLarge;
    @Inject
    @DataField(value="font-color-action")
    Button fontColorAction;
    @Inject
    @DataField(value="background-color-action")
    Button backgroundColorAction;
    @Inject
    @DataField(value="unordered-list-action")
    Button unorderedListAction;
    @Inject
    @DataField(value="ordered-list-action")
    Button orderedListAction;
    @Inject
    @DataField(value="outdent-list-action")
    Button outdentListAction;
    @Inject
    @DataField(value="indent-list-action")
    Button indentListAction;
    @Inject
    @DataField(value="align-left-action")
    Button alignLeftAction;
    @Inject
    @DataField(value="align-right-action")
    Button alignRightAction;
    @Inject
    @DataField(value="align-center-action")
    Button alignCenterAction;
    @Inject
    @DataField(value="undo-action")
    Button undoAction;
    @Inject
    @DataField(value="redo-action")
    Button redoAction;
    @Inject
    @DataField(value="switch-to-html-action")
    Button switchToHtmlAction;
    @Inject
    @DataField(value="background-color-button")
    Button backgroundColorButton;
    @Inject
    @DataField(value="background-color-input")
    Input backgroundColorInput;
    @Inject
    @DataField(value="font-color-button")
    Button fontColorButton;
    @Inject
    @DataField(value="font-color-input")
    Input fontColorInput;
    private TranslationService translationService;
    private HtmlEditorPresenter presenter;
    private HtmlEditorLibraryLoader libraryLoader;
    private EditorTitle title;
    private boolean loaded = false;
    private JavaScriptObject jsEditor;
    private String identifier;

    @Inject
    public HtmlEditorView(TranslationService translationService, HtmlEditorLibraryLoader libraryLoader) {
        this.translationService = translationService;
        this.libraryLoader = libraryLoader;
        this.title = new EditorTitle();
    }

    public void init(HtmlEditorPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void postConstruct() {
        this.libraryLoader.ensureLibrariesAreAvailable();
        this.configureToolbarTitles();
        this.setUpColorEditor(this.backgroundColorButton, this.backgroundColorInput);
        this.setUpColorEditor(this.fontColorButton, this.fontColorInput);
    }

    private void setUpColorEditor(Button button, Input input) {
        button.setOnclick(event -> this.handleColorSelection((MouseEvent)event, button, input));
        input.setOnclick(event -> this.handleColorSelection((MouseEvent)event, button, input));
    }

    private void handleColorSelection(MouseEvent event, Button button, Input input) {
        ColorPickerDialog dlg = new ColorPickerDialog();
        dlg.getElement().getStyle().setZIndex(9999);
        dlg.addDialogClosedHandler(closedEvent -> {
            if (!closedEvent.isCanceled()) {
                int[] rgb = ColorUtils.getRGB((String)dlg.getColor());
                String color = "#" + dlg.getColor();
                input.setValue("rgb(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ");");
            }
        });
        dlg.showRelativeTo((UIObject)ElementWrapperWidget.getWidget((HTMLElement)button));
        dlg.getElement().getStyle().setBackgroundColor("white");
    }

    @Override
    public void load() {
        if (!this.loaded) {
            this.identifier = String.valueOf(System.currentTimeMillis());
            this.loaded = true;
            this.configureScreenComponents(this.getEditorId(), this.getToolbarId());
            this.loadEditor(this.getEditorId(), this.getToolbarId());
        }
    }

    private String getToolbarId() {
        return "html-editor-toolbar-" + this.identifier;
    }

    private String getEditorId() {
        return "html-editor-" + this.identifier;
    }

    @Override
    public void destroy() {
        this.destroyEditor();
        this.loaded = false;
    }

    @Override
    public String getContent() {
        this.synchronizeView();
        return this.htmlEditor.getInnerHTML();
    }

    @Override
    public void setContent(String content) {
        this.htmlEditor.setInnerHTML(content);
    }

    public final native void synchronizeView();

    protected void configureScreenComponents(String editorId, String toolbarId) {
        this.htmlEditor.setId(editorId);
        this.toolbar.setId(toolbarId);
    }

    protected void loadEditor(String editorId, String toolbarId) {
        Scheduler.get().scheduleDeferred(() -> {
            this.initEditor(editorId, toolbarId);
            this.onResize();
        });
    }

    protected native void initEditor(String var1, String var2);

    protected native void destroyEditor();

    public void docksInteractionEvent(@Observes UberfireDocksInteractionEvent event) {
        Scheduler.get().scheduleDeferred(() -> this.onResize());
    }

    private void onResize() {
        String toolbarHeightCss = this.getOffsetHeight((HTMLElement)this.toolbar);
        int toolbarHeight = Integer.parseInt(toolbarHeightCss) + 14;
        this.container.getStyle().setProperty("width", "calc(100% - 14px)");
    }

    protected native String getOffsetHeight(HTMLElement var1);

    @Override
    public void alertReadOnly() {
        String message = this.translationService.format("HtmlEditorView.CantSaveReadOnly", new Object[0]);
        Window.alert((String)message);
    }

    @Override
    public void showLoading() {
        String message = this.translationService.format("HtmlEditorView.Loading", new Object[0]);
        this.showBusyIndicator(message);
    }

    @Override
    public void showSaving() {
        String message = this.translationService.format("HtmlEditorView.Saving", new Object[0]);
        this.showBusyIndicator(message);
    }

    @Override
    public EditorTitle getTitleWidget() {
        return this.title;
    }

    @Override
    public void refreshTitle(String value) {
        this.title.setText(value);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public boolean confirmClose() {
        String message = this.translationService.format("HtmlEditorView.DiscardUnsavedData", new Object[0]);
        return Window.confirm((String)message);
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.getElement());
    }

    private void configureToolbarTitles() {
        this.boldAction.setTitle(this.translationService.format("HtmlEditorView.Bold", new Object[0]));
        this.italicAction.setTitle(this.translationService.format("HtmlEditorView.Italic", new Object[0]));
        this.underlineAction.setTitle(this.translationService.format("HtmlEditorView.Underline", new Object[0]));
        this.createLinkAction.setTitle(this.translationService.format("HtmlEditorView.CreateLink", new Object[0]));
        this.removeLinkAction.setTitle(this.translationService.format("HtmlEditorView.RemoveLink", new Object[0]));
        this.insertImageAction.setTitle(this.translationService.format("HtmlEditorView.InsertImage", new Object[0]));
        this.insertTableAction.setTitle(this.translationService.format("HtmlEditorView.InsertTable", new Object[0]));
        this.bigTitleAction.setTitle(this.translationService.format("HtmlEditorView.BigTitle", new Object[0]));
        this.mediumTitleAction.setTitle(this.translationService.format("HtmlEditorView.MediumTitle", new Object[0]));
        this.smallTitleAction.setTitle(this.translationService.format("HtmlEditorView.SmallTitle", new Object[0]));
        this.paragraphAction.setTitle(this.translationService.format("HtmlEditorView.Paragraph", new Object[0]));
        this.preAction.setTitle(this.translationService.format("HtmlEditorView.Pre", new Object[0]));
        this.plainTextAction.setTitle(this.translationService.format("HtmlEditorView.PlainText", new Object[0]));
        this.quoteAction.setTitle(this.translationService.format("HtmlEditorView.Quote", new Object[0]));
        this.codeAction.setTitle(this.translationService.format("HtmlEditorView.Code", new Object[0]));
        this.fontSizeAction.setTitle(this.translationService.format("HtmlEditorView.FontSize", new Object[0]));
        this.fontColorAction.setTitle(this.translationService.format("HtmlEditorView.FontColor", new Object[0]));
        this.backgroundColorAction.setTitle(this.translationService.format("HtmlEditorView.BackgroundColor", new Object[0]));
        this.unorderedListAction.setTitle(this.translationService.format("HtmlEditorView.UnorderedList", new Object[0]));
        this.orderedListAction.setTitle(this.translationService.format("HtmlEditorView.OrderedList", new Object[0]));
        this.outdentListAction.setTitle(this.translationService.format("HtmlEditorView.OutdentList", new Object[0]));
        this.indentListAction.setTitle(this.translationService.format("HtmlEditorView.IndentList", new Object[0]));
        this.alignLeftAction.setTitle(this.translationService.format("HtmlEditorView.AlignLeft", new Object[0]));
        this.alignRightAction.setTitle(this.translationService.format("HtmlEditorView.AlignRight", new Object[0]));
        this.alignCenterAction.setTitle(this.translationService.format("HtmlEditorView.AlignCenter", new Object[0]));
        this.undoAction.setTitle(this.translationService.format("HtmlEditorView.Undo", new Object[0]));
        this.redoAction.setTitle(this.translationService.format("HtmlEditorView.Redo", new Object[0]));
        this.switchToHtmlAction.setTitle(this.translationService.format("HtmlEditorView.SwitchToHtmlView", new Object[0]));
    }
}

