/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.factory.definition;

import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;

public abstract class AbstractTypeDefinitionFactory<T>
implements TypeDefinitionFactory<T> {
    public abstract Set<Class<? extends T>> getAcceptedClasses();

    @Override
    public boolean accepts(Class<? extends T> type) {
        return this.getAcceptedClasses().contains(type);
    }

    @Override
    public boolean accepts(String id) {
        return this.getClass(id) != null;
    }

    @Override
    public T build(String id) {
        Class<T> clazz = this.getClass(id);
        if (null != clazz) {
            return this.build(clazz);
        }
        return null;
    }

    protected Class<? extends T> getClass(String id) {
        Set<Class<T>> acceptedClasses = this.getAcceptedClasses();
        if (null != acceptedClasses && !acceptedClasses.isEmpty()) {
            for (Class<T> clazz : acceptedClasses) {
                if (!BindableAdapterUtils.getGenericClassName(clazz).equals(id)) continue;
                return clazz;
            }
        }
        return null;
    }
}

