/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.impl;

import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavDividerImpl;
import org.dashbuilder.navigation.impl.NavGroupImpl;
import org.dashbuilder.navigation.impl.NavItemImpl;
import org.dashbuilder.navigation.impl.NavTreeImpl;

public class NavFactoryImpl
implements NavFactory {
    @Override
    public NavTree createNavTree(NavItem navItem) {
        if (navItem instanceof NavGroup) {
            NavGroup root = (NavGroup)navItem.cloneItem();
            root.setParent(null);
            root.getChildren().forEach(e -> e.setParent(null));
            return new NavTreeImpl(root);
        }
        NavItem i = navItem.cloneItem();
        i.setParent(null);
        NavTreeImpl tree = new NavTreeImpl();
        tree.getRootItems().add(i);
        return tree;
    }

    @Override
    public NavTree createNavTree() {
        return new NavTreeImpl();
    }

    @Override
    public NavGroup createNavGroup() {
        return new NavGroupImpl();
    }

    @Override
    public NavGroup createNavGroup(NavTree navTree) {
        NavGroup navGroup = this.createNavGroup();
        navGroup.setChildren(navTree.cloneTree().getRootItems());
        navGroup.getChildren().forEach(child -> child.setParent(navGroup));
        return navGroup;
    }

    @Override
    public NavItem createNavItem() {
        return new NavItemImpl();
    }

    @Override
    public NavDivider createDivider() {
        return new NavDividerImpl();
    }
}

