/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.spi;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public abstract class Streams {
    public static String toString(InputStream stream) {
        StringBuilder out = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[8192];
            InputStreamReader in = new InputStreamReader(stream, "UTF-8");
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    public static void write(InputStream source, OutputStream destination) {
        try {
            int read;
            byte[] buffer = new byte[8192];
            do {
                if ((read = source.read(buffer, 0, buffer.length)) <= 0) continue;
                destination.write(buffer, 0, read);
            } while (read >= 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream fromString(String data) {
        return new ByteArrayInputStream(data.getBytes());
    }

    public static void closeQuietly(Closeable source) {
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

