/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.codegen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationEngine {
    private static final Logger logger = LoggerFactory.getLogger(GenerationEngine.class);
    private static GenerationEngine singleton;
    private VelocityEngine velocityEngine = new VelocityEngine();
    private static boolean inited;

    public static GenerationEngine getInstance() throws Exception {
        if (singleton == null) {
            singleton = new GenerationEngine();
            singleton.init();
        }
        return singleton;
    }

    private void init() throws Exception {
        if (!inited) {
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "class");
            properties.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.JdkLogChute");
            this.velocityEngine.init(properties);
            inited = true;
        }
    }

    public void generate(GenerationContext generationContext) throws Exception {
        VelocityContext context = this.buildContext(generationContext);
        String templatesPath = generationContext.getTemplatesPath();
        String initialTemplate = generationContext.getInitialTemplate();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting code adf with templatesPath: " + templatesPath + ", initialTemplate: " + initialTemplate);
        }
        String templatePath = this.getFullVelocityPath(templatesPath, initialTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("Initial templatePath: " + templatePath);
        }
        StringWriter writer = new StringWriter();
        Template t = this.velocityEngine.getTemplate(templatePath);
        t.merge((Context)context, (Writer)writer);
    }

    private VelocityContext buildContext(GenerationContext generationContext) {
        VelocityContext context = new VelocityContext();
        context.put("engine", (Object)this);
        context.put("context", (Object)generationContext);
        context.put("dataModel", (Object)generationContext.getDataModel());
        context.put("nameTool", (Object)new GenerationTools());
        generationContext.setVelocityContext(context);
        return context;
    }

    public void generateAsset(GenerationContext generationContext, String template, String filePath) throws Exception {
        String templatePath = this.getFullVelocityPath(generationContext.getTemplatesPath(), template);
        VelocityContext context = this.buildContext(generationContext);
        Template t = this.velocityEngine.getTemplate(templatePath);
        StringWriter writer = new StringWriter();
        generationContext.setCurrentOutput(writer);
        t.merge((Context)context, (Writer)writer);
        if (generationContext.getOutputPath() != null) {
            File fout = new File(generationContext.getOutputPath(), filePath);
            fout.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(fout, false);
            IOUtils.write((String)writer.toString(), (OutputStream)fos);
        }
        if (generationContext.getGenerationListener() != null) {
            generationContext.getGenerationListener().assetGenerated(filePath, writer.toString());
        }
    }

    public void generateConstructors(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateAttribute(GenerationContext generationContext, ObjectProperty attribute, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateMethod(GenerationContext generationContext, Method method, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateNestedClass(GenerationContext generationContext, JavaClass nestedClass, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateSetterGetter(GenerationContext generationContext, ObjectProperty attribute, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateEquals(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateHashCode(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateTypeAnnotation(GenerationContext generationContext, Annotation annotation, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateFieldAnnotation(GenerationContext generationContext, Annotation annotation, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateSubTemplate(GenerationContext generationContext, String template) throws Exception {
        String templatePath = null;
        try {
            templatePath = this.getFullVelocityPath(generationContext.getTemplatesPath(), template);
            Template t = this.velocityEngine.getTemplate(templatePath);
            t.merge((Context)generationContext.getVelocityContext(), generationContext.getCurrentOutput());
        }
        catch (Exception e) {
            logger.error("An error was produced during template adf: template: " + template + ", templatePath: " + templatePath, (Throwable)e);
        }
    }

    public String generateDefaultConstructorString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_default_constructor");
    }

    public String generateAllFieldsConstructorString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_allfields_constructor");
    }

    public String generateKeyFieldsConstructorString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_keyfields_constructor");
    }

    public String generatePositionFieldsConstructorString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_positionfields_constructor");
    }

    public String generateAnnotationString(GenerationContext generationContext, Annotation annotation) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("annotation", (Object)annotation);
        return this.generateSubTemplateString(generationContext, "java_annotation");
    }

    public String generateMethodString(GenerationContext generationContext, Method method, String indent) throws Exception {
        return GenerationEngine.indentLines(this.generateMethodString(generationContext, method), indent);
    }

    public String generateMethodString(GenerationContext generationContext, Method method) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("attr", (Object)method);
        return this.generateSubTemplateString(generationContext, "java_method");
    }

    public String generateNestedClassString(GenerationContext generationContext, JavaClass javaClass, String indent) throws Exception {
        return GenerationEngine.indentLines(this.generateNestedClassString(generationContext, javaClass), indent);
    }

    public String generateNestedClassString(GenerationContext generationContext, JavaClass javaClass) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("attr", (Object)javaClass);
        return this.generateSubTemplateString(generationContext, "java_nested_class");
    }

    public String generateFieldString(GenerationContext generationContext, ObjectProperty attribute) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("attr", (Object)attribute);
        return this.generateSubTemplateString(generationContext, "java_attribute_2");
    }

    public String generateFieldGetterString(GenerationContext generationContext, ObjectProperty attribute) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("attr", (Object)attribute);
        return this.generateSubTemplateString(generationContext, "java_getter");
    }

    public String generateFieldSetterString(GenerationContext generationContext, ObjectProperty attribute) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("attr", (Object)attribute);
        return this.generateSubTemplateString(generationContext, "java_setter");
    }

    public String generateEqualsString(GenerationContext generationContext, DataObject dataObject, String indent) throws Exception {
        return GenerationEngine.indentLines(this.generateEqualsString(generationContext, dataObject), indent);
    }

    public String generateEqualsString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_equals2");
    }

    public String generateHashCodeString(GenerationContext generationContext, DataObject dataObject, String indent) throws Exception {
        return GenerationEngine.indentLines(this.generateHashCodeString(generationContext, dataObject), indent);
    }

    public String generateHashCodeString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_hashCode2");
    }

    public String generateAllConstructorsString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        return this.generateAllConstructorsString(generationContext, dataObject, null);
    }

    public String generateAllConstructorsString(GenerationContext generationContext, DataObject dataObject, String indent) throws Exception {
        StringBuilder sb = new StringBuilder();
        List<ObjectProperty> allFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterAssignableFields(dataObject));
        List<ObjectProperty> positionFields = DataModelUtils.sortByPosition(DataModelUtils.filterPositionFields(dataObject));
        List<ObjectProperty> keyFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterKeyFields(dataObject));
        boolean needsAllFieldsConstructor = allFields.size() > 0;
        boolean needsPositionFieldsConstructor = positionFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, positionFields) && !DataModelUtils.equalsByFieldType(allFields, positionFields);
        boolean needsKeyFieldsConstructor = keyFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, keyFields) && !DataModelUtils.equalsByFieldType(allFields, keyFields) && !DataModelUtils.equalsByFieldName(positionFields, keyFields) && !DataModelUtils.equalsByFieldType(positionFields, keyFields);
        sb.append(this.generateDefaultConstructorString(generationContext, dataObject));
        if (needsAllFieldsConstructor) {
            sb.append(GenerationTools.EOL).append(GenerationTools.EOL);
            sb.append(this.generateAllFieldsConstructorString(generationContext, dataObject));
        }
        if (needsPositionFieldsConstructor) {
            sb.append(GenerationTools.EOL).append(GenerationTools.EOL);
            sb.append(this.generatePositionFieldsConstructorString(generationContext, dataObject));
        }
        if (needsKeyFieldsConstructor) {
            sb.append(GenerationTools.EOL).append(GenerationTools.EOL);
            sb.append(this.generateKeyFieldsConstructorString(generationContext, dataObject));
        }
        return GenerationEngine.indentLines(sb.toString(), indent);
    }

    public String generateAllAnnotationsString(GenerationContext generationContext, HasAnnotations hasAnnotations) throws Exception {
        return this.generateAllAnnotationsString(generationContext, hasAnnotations, null);
    }

    public String generateAllAnnotationsString(GenerationContext generationContext, HasAnnotations hasAnnotations, String indent) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        StringBuilder sb = new StringBuilder();
        List<Annotation> annotations = ((GenerationTools)vc.get("nameTool")).sortedAnnotations(hasAnnotations);
        boolean isFirst = true;
        for (Annotation a : annotations) {
            if (!isFirst) {
                sb.append(GenerationTools.EOL);
            }
            isFirst = false;
            sb.append(this.generateAnnotationString(generationContext, a));
        }
        return GenerationEngine.indentLines(sb.toString(), indent);
    }

    public String generateCompleteFieldString(GenerationContext generationContext, ObjectProperty attribute) throws Exception {
        return this.generateCompleteFieldString(generationContext, attribute, null);
    }

    public String generateCompleteFieldString(GenerationContext generationContext, ObjectProperty attribute, String indent) throws Exception {
        StringBuilder sb = new StringBuilder();
        String annotationsString = this.generateAllAnnotationsString(generationContext, attribute);
        if (annotationsString != null && !"".endsWith(annotationsString)) {
            sb.append(annotationsString);
            sb.append(GenerationTools.EOL);
        }
        sb.append(this.generateFieldString(generationContext, attribute));
        return GenerationEngine.indentLines(sb.toString(), indent);
    }

    public String generateFieldGetterSetterString(GenerationContext generationContext, ObjectProperty attribute) throws Exception {
        return this.generateFieldGetterSetterString(generationContext, attribute, null);
    }

    public String generateFieldGetterSetterString(GenerationContext generationContext, ObjectProperty attribute, String indent) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generateFieldGetterString(generationContext, attribute)).append(GenerationTools.EOL).append(GenerationTools.EOL);
        sb.append(this.generateFieldSetterString(generationContext, attribute));
        return GenerationEngine.indentLines(sb.toString(), indent);
    }

    public String generateJavaClassString(GenerationContext generationContext, DataObject dataObject) throws Exception {
        VelocityContext vc = this.buildContext(generationContext);
        vc.put("currentDataObject", (Object)dataObject);
        return this.generateSubTemplateString(generationContext, "java_class2");
    }

    public String generateSubTemplateString(GenerationContext generationContext, String template) throws Exception {
        StringWriter writer = new StringWriter();
        generationContext.setCurrentOutput(writer);
        String templatePath = null;
        try {
            templatePath = this.getFullVelocityPath(generationContext.getTemplatesPath(), template);
            Template t = this.velocityEngine.getTemplate(templatePath);
            t.merge((Context)generationContext.getVelocityContext(), (Writer)writer);
        }
        catch (Exception e) {
            logger.error("An error was produced during template adf: template: " + template + ", templatePath: " + templatePath, (Throwable)e);
        }
        return writer.toString();
    }

    public static String indentLines(String source, String indent) throws Exception {
        if (indent == null || "".equals(indent)) {
            return source;
        }
        BufferedReader reader = new BufferedReader(new StringReader(source));
        StringBuilder out = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        String line = reader.readLine();
        if (line != null) {
            out.append(indent);
            out.append(line);
            while ((line = reader.readLine()) != null) {
                out.append(lineSeparator);
                out.append(indent);
                out.append(line);
            }
        }
        return out.toString();
    }

    private String getFullVelocityPath(String templatesPath, String template) {
        return "/" + templatesPath + "/" + template + ".vm";
    }

    static {
        inited = false;
    }
}

