/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.drools.model.Global;
import org.drools.model.Rule;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsConstraint<Solution_>
implements Constraint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsConstraint.class);
    private final DroolsConstraintFactory<Solution_> constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private final boolean positive;
    private final List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList;
    private final DroolsAbstractConstraintStream<Solution_> scoringStream;
    private Function<Solution_, Score<?>> constraintWeightExtractor;

    public DroolsConstraint(DroolsConstraintFactory<Solution_> constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, boolean positive, List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList, DroolsAbstractConstraintStream<Solution_> scoringStream) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.positive = positive;
        this.fromStreamList = fromStreamList;
        this.scoringStream = scoringStream;
    }

    public Score<?> extractConstraintWeight(Solution_ workingSolution) {
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        return this.positive ? constraintWeight : constraintWeight.negate();
    }

    private Set<DroolsAbstractConstraintStream<Solution_>> assembleAllStreams() {
        LinkedHashSet<DroolsAbstractConstraintStream<Solution_>> streamSet = new LinkedHashSet<DroolsAbstractConstraintStream<Solution_>>();
        for (DroolsAbstractConstraintStream droolsAbstractConstraintStream : this.fromStreamList) {
            streamSet.addAll(this.assembleAllStreams(droolsAbstractConstraintStream));
        }
        return streamSet;
    }

    private Collection<DroolsAbstractConstraintStream<Solution_>> assembleAllStreams(DroolsAbstractConstraintStream<Solution_> parent) {
        LinkedHashSet<DroolsAbstractConstraintStream<Solution_>> streamSet = new LinkedHashSet<DroolsAbstractConstraintStream<Solution_>>();
        streamSet.add(parent);
        for (DroolsAbstractConstraintStream<Solution_> child : parent.getChildStreams()) {
            streamSet.addAll(this.assembleAllStreams(child));
        }
        return streamSet;
    }

    private Set<DroolsAbstractConstraintStream<Solution_>> getPredecessors(Collection<DroolsAbstractConstraintStream<Solution_>> constraintStreamCollection, DroolsAbstractConstraintStream<Solution_> child) {
        LinkedHashSet<DroolsAbstractConstraintStream<Solution_>> predecessorSet = new LinkedHashSet<DroolsAbstractConstraintStream<Solution_>>();
        constraintStreamCollection.stream().filter(constraintStream -> constraintStream.getChildStreams().contains(child)).forEach(parentConstraintStream -> {
            predecessorSet.addAll(this.getPredecessors(constraintStreamCollection, (DroolsAbstractConstraintStream<Solution_>)parentConstraintStream));
            predecessorSet.add((DroolsAbstractConstraintStream<Solution_>)parentConstraintStream);
        });
        return predecessorSet;
    }

    private Set<DroolsAbstractConstraintStream<Solution_>> assembleScoringStreamTree(DroolsAbstractConstraintStream<Solution_> rootConstraintStream) {
        Set<DroolsAbstractConstraintStream<Solution_>> constraintStreamSet = this.getPredecessors(this.assembleAllStreams(), rootConstraintStream);
        constraintStreamSet.add(rootConstraintStream);
        return constraintStreamSet;
    }

    public void createRules(Map<DroolsAbstractConstraintStream<Solution_>, Rule> ruleLibrary, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        this.assembleScoringStreamTree(this.scoringStream).forEach(stream -> ruleLibrary.compute((DroolsAbstractConstraintStream<Solution_>)stream, (key, rule) -> {
            if (rule == null) {
                Rule newRule = key.buildRule(this, scoreHolderGlobal).orElse(null);
                if (newRule == null) {
                    LOGGER.trace("Constraint stream {} resulted in no new Drools rules.", key);
                } else {
                    LOGGER.trace("Constraint stream {} created new Drools rule {}.", key, (Object)newRule);
                }
                return newRule;
            }
            LOGGER.trace("Constraint stream {} reused Drools rule {}.", key, rule);
            return rule;
        }));
    }

    @Override
    public DroolsConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    public String toString() {
        return "DroolsConstraint(" + this.getConstraintId() + ") in " + this.fromStreamList.size() + " from() stream(s)";
    }
}

