/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAccumulateContext;

final class DroolsUniAccumulateFunctionBridge<A, ResultContainer_, NewA>
implements AccumulateFunction<DroolsAccumulateContext<ResultContainer_>> {
    private final Supplier<ResultContainer_> supplier;
    private final BiFunction<ResultContainer_, A, Runnable> accumulator;
    private final Function<ResultContainer_, NewA> finisher;

    public DroolsUniAccumulateFunctionBridge(UniConstraintCollector<A, ResultContainer_, NewA> collector) {
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    public DroolsUniAccumulateFunctionBridge() {
        throw new UnsupportedOperationException("Serialization is not supported.");
    }

    public DroolsAccumulateContext<ResultContainer_> createContext() {
        return new DroolsAccumulateContext<ResultContainer_>(this.supplier.get());
    }

    public void init(DroolsAccumulateContext<ResultContainer_> context) {
        context.getUndoMap().clear();
    }

    public void accumulate(DroolsAccumulateContext<ResultContainer_> context, Object value) {
        Map<Object, Runnable> undoMap = context.getUndoMap();
        if (undoMap.containsKey(value)) {
            throw new IllegalStateException("Undo for (" + value + ") already exists.");
        }
        Runnable undo = this.accumulator.apply(context.getContainer(), value);
        undoMap.put(value, undo);
    }

    public void reverse(DroolsAccumulateContext<ResultContainer_> context, Object value) {
        Runnable undo = context.getUndoMap().remove(value);
        if (undo == null) {
            throw new IllegalStateException("Undo for (" + value + ") does not exist.");
        }
        undo.run();
    }

    public Object getResult(DroolsAccumulateContext<ResultContainer_> context) {
        return this.finisher.apply(context.getContainer());
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput out) {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in) {
        throw new UnsupportedOperationException();
    }
}

