/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.mariadb.jdbc.internal.util.buffer.ReadUtil;

public class DecompressInputStream
extends InputStream {
    InputStream baseStream;
    int remainingBytes;
    byte[] header;
    boolean doDecompress;
    ByteArrayInputStream decompressedByteStream;

    public DecompressInputStream(InputStream baseStream) {
        this.baseStream = baseStream;
        this.header = new byte[7];
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (len == 0 || off < 0 || bytes == null) {
            throw new InvalidParameterException();
        }
        if (this.remainingBytes == 0) {
            this.nextPacket();
        }
        int bytesToRead = Math.min(this.remainingBytes, len);
        int ret = this.doDecompress ? this.decompressedByteStream.read(bytes, off, bytesToRead) : this.baseStream.read(bytes, off, bytesToRead);
        if (ret <= 0) {
            throw new EOFException("got " + ret + " bytes, bytesToRead = " + bytesToRead);
        }
        this.remainingBytes -= ret;
        return ret;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.read(buffer) == 0) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    private void nextPacket() throws IOException {
        ReadUtil.readFully(this.baseStream, this.header);
        int compressedLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        int decompressedLength = (this.header[4] & 0xFF) + ((this.header[5] & 0xFF) << 8) + ((this.header[6] & 0xFF) << 16);
        if (decompressedLength != 0) {
            this.doDecompress = true;
            this.remainingBytes += decompressedLength;
            byte[] compressedBuffer = new byte[compressedLength];
            byte[] decompressedBuffer = new byte[decompressedLength];
            ReadUtil.readFully(this.baseStream, compressedBuffer);
            Inflater inflater = new Inflater();
            inflater.setInput(compressedBuffer);
            try {
                int actualUncompressBytes = inflater.inflate(decompressedBuffer);
                if (actualUncompressBytes != decompressedLength) {
                    throw new IOException("Invalid stream length after decompression " + actualUncompressBytes + ",expected " + decompressedLength);
                }
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe);
            }
            inflater.end();
            this.decompressedByteStream = new ByteArrayInputStream(decompressedBuffer);
        } else {
            this.doDecompress = false;
            this.remainingBytes += compressedLength;
            this.decompressedByteStream = null;
        }
    }
}

