/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.explorer.backend.server.Content;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.Space;

public class ProjectExplorerContentResolver {
    @Inject
    protected User identity;
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private KieModuleService moduleService;
    private ExplorerServiceHelper helper;
    private ExplorerServiceHelper explorerServiceHelper;
    private WorkspaceProjectService projectService;

    @Inject
    public ProjectExplorerContentResolver(KieModuleService moduleService, ExplorerServiceHelper helper, ExplorerServiceHelper explorerServiceHelper, WorkspaceProjectService projectService) {
        this.moduleService = moduleService;
        this.helper = helper;
        this.explorerServiceHelper = explorerServiceHelper;
        this.projectService = projectService;
    }

    public ProjectExplorerContent resolve(ProjectExplorerContentQuery query) {
        Content content = this.setupSelectedItems(query);
        this.setSelectedModule(content);
        this.setSelectedPackage(content);
        this.setSelectedItem(content);
        if (content.getSelectedProject() == null || content.getSelectedModule() == null) {
            return this.emptyModuleExplorerContent(content);
        }
        return this.moduleExplorerContentWithSelections(content, query.getOptions());
    }

    private ProjectExplorerContent moduleExplorerContentWithSelections(Content content, ActiveOptions options) {
        this.setFolderListing(content, options);
        this.setSiblings(content);
        this.helper.store(content.getSelectedProject(), content.getSelectedModule(), content.getFolderListing(), content.getSelectedPackage(), options);
        return new ProjectExplorerContent(content.getSelectedProject(), content.getSelectedModule(), content.getFolderListing(), content.getSiblings());
    }

    private void setFolderListing(Content content, ActiveOptions options) {
        content.setFolderListing(this.helper.getFolderListing(content.getSelectedItem(), content.getSelectedModule(), content.getSelectedPackage(), options));
    }

    private void setSiblings(Content content) {
        ArrayList<FolderItem> result;
        if (content.getFolderListing().getSegments().size() > 1) {
            ListIterator li = content.getFolderListing().getSegments().listIterator(content.getFolderListing().getSegments().size());
            while (li.hasPrevious()) {
                FolderItem currentItem = (FolderItem)li.previous();
                ArrayList<FolderItem> result2 = new ArrayList<FolderItem>();
                result2.add(currentItem);
                if (currentItem.getItem() instanceof Package) {
                    result2.addAll(this.getSegmentSiblings((Package)currentItem.getItem()));
                } else if (currentItem.getItem() instanceof org.uberfire.backend.vfs.Path) {
                    result2.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)currentItem.getItem()));
                }
                content.getSiblings().put(currentItem, result2);
            }
        }
        if (content.getSelectedItem() != null && content.getSelectedItem().getType().equals((Object)FolderItemType.FOLDER) && !content.getSiblings().containsKey(content.getSelectedItem())) {
            result = new ArrayList<FolderItem>();
            result.add(content.getSelectedItem());
            if (content.getSelectedItem().getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)content.getSelectedItem().getItem()));
            } else if (content.getSelectedItem().getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)content.getSelectedItem().getItem()));
            }
            content.getSiblings().put(content.getSelectedItem(), result);
        }
        if (content.getFolderListing().getItem().getType().equals((Object)FolderItemType.FOLDER) && !content.getSiblings().containsKey(content.getFolderListing().getItem())) {
            result = new ArrayList();
            result.add(content.getFolderListing().getItem());
            if (content.getFolderListing().getItem().getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)content.getFolderListing().getItem().getItem()));
            } else if (content.getFolderListing().getItem().getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)content.getFolderListing().getItem().getItem()));
            }
            if (!result.isEmpty()) {
                content.getSiblings().put(content.getFolderListing().getItem(), result);
            }
        }
        for (Map.Entry<FolderItem, List<FolderItem>> e : content.getSiblings().entrySet()) {
            Collections.sort(e.getValue(), Sorters.ITEM_SORTER);
        }
    }

    private ProjectExplorerContent emptyModuleExplorerContent(Content content) {
        return new ProjectExplorerContent(content.getSelectedProject(), content.getSelectedModule(), new FolderListing(null, Collections.emptyList(), Collections.emptyList()), Collections.emptyMap());
    }

    private void setSelectedPackage(Content content) {
        if (content.getSelectedModule() == null) {
            content.setSelectedPackage(null);
        } else {
            Module selectedModule = content.getSelectedModule();
            if (content.getSelectedPackage() != null && !content.getSelectedPackage().getModuleRootPath().equals(selectedModule.getRootPath())) {
                content.setSelectedPackage(null);
                content.setSelectedItem(null);
            }
        }
    }

    private void setSelectedItem(Content content) {
        if (content.getSelectedModule() == null) {
            content.setSelectedItem(null);
        } else {
            Module selectedModule = content.getSelectedModule();
            if (content.getSelectedItem() != null) {
                org.uberfire.backend.vfs.Path itemPath;
                Module owningModule;
                if (content.getSelectedItem().getItem() instanceof Package) {
                    Package pkg = (Package)content.getSelectedItem().getItem();
                    if (!pkg.getModuleRootPath().equals(selectedModule.getRootPath())) {
                        content.setSelectedPackage(null);
                        content.setSelectedItem(null);
                    }
                } else if (content.getSelectedItem().getItem() instanceof org.uberfire.backend.vfs.Path && !(owningModule = this.moduleService.resolveModule(itemPath = (org.uberfire.backend.vfs.Path)content.getSelectedItem().getItem())).getRootPath().equals(selectedModule.getRootPath())) {
                    content.setSelectedPackage(null);
                    content.setSelectedItem(null);
                }
            }
        }
    }

    private void setSelectedModule(Content content) {
        if (content.getSelectedModule() == null || content.getSelectedProject().getMainModule() != null && !content.getSelectedProject().getMainModule().getPom().equals((Object)content.getSelectedModule().getPom())) {
            content.setSelectedModule(content.getSelectedProject().getMainModule());
        } else {
            content.setSelectedModule(content.getSelectedModule());
        }
    }

    protected Content setupSelectedItems(ProjectExplorerContentQuery query) {
        Content content = new Content(query, this.getProject(query));
        UserExplorerLastData lastContent = this.helper.getLastContent();
        UserExplorerData userContent = this.helper.loadUserContent();
        if (!lastContent.isDataEmpty()) {
            if (query.getRepository() == null && query.getModule() == null) {
                if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                    Repository lastRepo = lastContent.getLastPackage().getRepository();
                    content.setSelectedProject(this.projectService.resolveProject(lastRepo.getSpace(), (Branch)lastRepo.getBranch(lastContent.getLastPackage().getBranch()).get()));
                    content.setSelectedModule(lastContent.getLastPackage().getModule());
                    content.setSelectedPackage(lastContent.getLastPackage().getPkg());
                    content.setSelectedItem(null);
                } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                    content.setSelectedProject(this.projectService.resolveProject(lastContent.getLastFolderItem().getRepository().getSpace(), (Branch)lastContent.getLastFolderItem().getRepository().getBranch(lastContent.getLastFolderItem().getBranch()).get()));
                    content.setSelectedModule(lastContent.getLastFolderItem().getModule());
                    content.setSelectedItem(lastContent.getLastFolderItem().getItem());
                    content.setSelectedPackage(null);
                }
            } else if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                if (query.getRepository() != null && !query.getRepository().equals(lastContent.getLastPackage().getRepository()) || query.getBranch() != null && !query.getBranch().getName().equals(lastContent.getLastPackage().getBranch()) || query.getModule() != null && !query.getModule().equals((Object)lastContent.getLastPackage().getModule())) {
                    content.setSelectedProject(this.loadProject(query.getRepository().getSpace(), (Branch)query.getRepository().getBranch(query.getBranch().getName()).get()));
                    content.setSelectedModule(this.loadModule(content.getSelectedProject(), query.getModule()));
                    content.setSelectedPackage(this.loadPackage(content.getSelectedProject(), content.getSelectedModule(), query.getPkg(), userContent));
                    content.setSelectedItem(null);
                } else {
                    content.setSelectedProject(this.loadProject(lastContent.getLastPackage().getRepository().getSpace(), (Branch)lastContent.getLastPackage().getRepository().getBranch(lastContent.getLastPackage().getBranch()).get()));
                    content.setSelectedModule(this.loadModule(content.getSelectedProject(), lastContent.getLastPackage().getModule()));
                    content.setSelectedPackage(this.loadPackage(content.getSelectedProject(), content.getSelectedModule(), lastContent.getLastPackage().getPkg(), userContent));
                    content.setSelectedItem(null);
                }
            } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                if (lastContent.getOptions().contains(Option.BUSINESS_CONTENT)) {
                    content.setSelectedProject(this.loadProject(lastContent.getLastPackage().getRepository().getSpace(), (Branch)lastContent.getLastFolderItem().getRepository().getBranch(lastContent.getLastPackage().getBranch()).get()));
                    content.setSelectedModule(this.loadModule(content.getSelectedProject(), lastContent.getLastFolderItem().getModule()));
                    content.setSelectedItem(null);
                    content.setSelectedPackage(null);
                } else if (query.getRepository() != null && !query.getRepository().equals(lastContent.getLastFolderItem().getRepository()) || query.getModule() != null && !query.getModule().equals((Object)lastContent.getLastFolderItem().getModule())) {
                    content.setSelectedProject(this.loadProject(query.getRepository().getSpace(), (Branch)query.getRepository().getBranch(query.getBranch().getName()).get()));
                    content.setSelectedModule(this.loadModule(content.getSelectedProject(), query.getModule()));
                    content.setSelectedItem(null);
                    content.setSelectedPackage(null);
                } else {
                    content.setSelectedProject(this.loadProject(query.getRepository().getSpace(), (Branch)lastContent.getLastFolderItem().getRepository().getBranch(lastContent.getLastFolderItem().getBranch()).get()));
                    content.setSelectedModule(this.loadModule(content.getSelectedProject(), lastContent.getLastFolderItem().getModule()));
                    content.setSelectedItem(this.loadFolderItem(content.getSelectedProject(), content.getSelectedModule(), lastContent.getLastFolderItem().getItem(), userContent));
                    content.setSelectedPackage(null);
                }
            }
        }
        return content;
    }

    private WorkspaceProject getProject(ProjectExplorerContentQuery query) {
        if (query.getBranch() == null) {
            return null;
        }
        return this.projectService.resolveProject(query.getRepository().getSpace(), query.getBranch());
    }

    List<FolderItem> getSegmentSiblings(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (nioPath.equals(nioPath.getRoot())) {
            result.add(this.explorerServiceHelper.toFolderItem(nioPath));
        } else {
            Path nioParentPath = nioPath.getParent();
            for (Path sibling : this.getDirectoryIterator(nioParentPath)) {
                result.add(this.explorerServiceHelper.toFolderItem(sibling));
            }
        }
        return result;
    }

    Iterable<Path> getDirectoryIterator(Path nioParentPath) {
        return Files.newDirectoryStream((Path)nioParentPath, (DirectoryStream.Filter)this.dotFileFilter);
    }

    private List<FolderItem> getSegmentSiblings(Package pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package parentPkg = this.moduleService.resolveParentPackage(pkg);
        if (parentPkg == null) {
            return Collections.emptyList();
        }
        Set siblings = this.moduleService.resolvePackages(parentPkg);
        if (siblings != null && !siblings.isEmpty()) {
            for (Package sibling : siblings) {
                if (sibling.equals((Object)pkg)) continue;
                result.add(this.explorerServiceHelper.toFolderItem(sibling));
            }
        }
        return result;
    }

    private WorkspaceProject loadProject(Space space, Branch branch) {
        if (branch == null) {
            return null;
        }
        return this.projectService.resolveProject(space, branch);
    }

    private Module loadModule(WorkspaceProject project, Module module) {
        if (project == null) {
            return null;
        }
        if (module != null) {
            return module;
        }
        return project.getMainModule();
    }

    private Package loadPackage(WorkspaceProject project, Module module, Package pkg, UserExplorerData content) {
        if (module == null) {
            return null;
        }
        if (pkg != null) {
            return pkg;
        }
        return content.getPackage(project, module);
    }

    private FolderItem loadFolderItem(WorkspaceProject project, Module module, FolderItem item, UserExplorerData content) {
        if (module == null) {
            return null;
        }
        if (item != null) {
            return item;
        }
        return content.getFolderItem(project, module);
    }
}

