/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl;
import javax.validation.Validator;

public class LoadBalancerIngressBuilder
extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder>
implements VisitableBuilder<LoadBalancerIngress, LoadBalancerIngressBuilder> {
    LoadBalancerIngressFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LoadBalancerIngressBuilder() {
        this(true);
    }

    public LoadBalancerIngressBuilder(Boolean validationEnabled) {
        this(new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance) {
        this(instance, (Boolean)true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerIngressBuilder(Validator validator) {
        this(new LoadBalancerIngress(), (Boolean)true);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance, Validator validator) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LoadBalancerIngress build() {
        LoadBalancerIngress buildable = new LoadBalancerIngress(this.fluent.getHostname(), this.fluent.getIp());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

