/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;

public abstract class DroolsRuleStructure {
    private final LongSupplier variableIdSupplier;

    protected DroolsRuleStructure(LongSupplier variableIdSupplier) {
        this.variableIdSupplier = variableIdSupplier;
    }

    public final <X> Variable<X> createVariable(Class<X> clz, String name) {
        return DSL.declarationOf(clz, (String)this.decorateVariableName(name));
    }

    public final <X> Variable<X> createVariable(Class<X> clz, String name, DeclarationSource source) {
        return DSL.declarationOf(clz, (String)this.decorateVariableName(name), (DeclarationSource)source);
    }

    private String decorateVariableName(String name) {
        return "$var" + this.variableIdSupplier.getAsLong() + "_" + name;
    }

    public final <X> Variable<X> createVariable(String name) {
        return this.createVariable(Object.class, name);
    }

    public final <X> Variable<X> createVariable(String name, DeclarationSource source) {
        return this.createVariable(Object.class, name, source);
    }

    public final List<RuleItemBuilder<?>> rebuildSupportingRuleItems(RuleItemBuilder<?> ... toAdd) {
        ArrayList supporting = new ArrayList(this.getSupportingRuleItems());
        for (RuleItemBuilder<?> ruleItem : toAdd) {
            supporting.add(ruleItem);
        }
        return supporting;
    }

    public LongSupplier getVariableIdSupplier() {
        return this.variableIdSupplier;
    }

    public abstract DroolsPatternBuilder<Object> getPrimaryPattern();

    public abstract List<RuleItemBuilder<?>> getSupportingRuleItems();
}

