/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.dashbuilder.navigation.layout.LayoutTemplateContext;
import org.dashbuilder.navigation.layout.LayoutTemplateInfo;
import org.dashbuilder.navigation.service.LayoutTemplateAnalyzer;
import org.dashbuilder.navigation.service.PerspectivePluginServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.LayoutServicesImpl;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@ApplicationScoped
@Service
public class PerspectivePluginServicesImpl
implements PerspectivePluginServices {
    private PluginServicesImpl pluginServices;
    private LayoutServicesImpl layoutServices;
    private LayoutTemplateAnalyzer layoutTemplateAnalyzer;

    public PerspectivePluginServicesImpl() {
    }

    @Inject
    public PerspectivePluginServicesImpl(PluginServicesImpl pluginServices, LayoutServicesImpl layoutServices, LayoutTemplateAnalyzer layoutTemplateAnalyzer) {
        this.pluginServices = pluginServices;
        this.layoutServices = layoutServices;
        this.layoutTemplateAnalyzer = layoutTemplateAnalyzer;
    }

    public Collection<Plugin> listPlugins() {
        return this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT);
    }

    public Plugin getPerspectivePlugin(String perspectiveName) {
        if (perspectiveName == null) {
            return null;
        }
        for (Plugin plugin : this.listPlugins()) {
            if (!PluginType.PERSPECTIVE_LAYOUT.equals((Object)plugin.getType()) || !plugin.getName().equals(perspectiveName)) continue;
            return plugin;
        }
        return null;
    }

    public LayoutTemplate getLayoutTemplate(String perspectiveName) {
        Plugin perspectivePlugin = this.getPerspectivePlugin(perspectiveName);
        return perspectivePlugin != null ? this.getLayoutTemplate(perspectivePlugin) : null;
    }

    public LayoutTemplateInfo getLayoutTemplateInfo(String perspectiveName) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(perspectiveName);
        return layoutTemplate != null ? this.getLayoutTemplateInfo(layoutTemplate) : null;
    }

    public LayoutTemplate getLayoutTemplate(Plugin perspectivePlugin) {
        LayoutEditorModel layoutEditorModel = this.pluginServices.getLayoutEditor(perspectivePlugin.getPath(), PluginType.PERSPECTIVE_LAYOUT);
        return this.layoutServices.convertLayoutFromString(layoutEditorModel.getLayoutEditorModel());
    }

    public LayoutTemplateInfo getLayoutTemplateInfo(Plugin perspectivePlugin, LayoutTemplateContext layoutCtx) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(perspectivePlugin);
        LayoutRecursionIssue recursiveIssue = this.layoutTemplateAnalyzer.analyzeRecursion(layoutTemplate, layoutCtx);
        boolean hasNavComps = this.layoutTemplateAnalyzer.hasNavigationComponents(layoutTemplate);
        return new LayoutTemplateInfo(layoutTemplate, hasNavComps, recursiveIssue);
    }

    public LayoutTemplateInfo getLayoutTemplateInfo(LayoutTemplate layoutTemplate) {
        LayoutRecursionIssue recursiveIssue = this.layoutTemplateAnalyzer.analyzeRecursion(layoutTemplate);
        boolean hasNavComps = this.layoutTemplateAnalyzer.hasNavigationComponents(layoutTemplate);
        return new LayoutTemplateInfo(layoutTemplate, hasNavComps, recursiveIssue);
    }
}

