/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.HostAliasFluent;
import io.fabric8.kubernetes.api.model.HostAliasFluentImpl;
import javax.validation.Validator;

public class HostAliasBuilder
extends HostAliasFluentImpl<HostAliasBuilder>
implements VisitableBuilder<HostAlias, HostAliasBuilder> {
    HostAliasFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HostAliasBuilder() {
        this(true);
    }

    public HostAliasBuilder(Boolean validationEnabled) {
        this(new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, HostAlias instance) {
        this(fluent, instance, true);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, HostAlias instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostnames(instance.getHostnames());
        fluent.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public HostAliasBuilder(HostAlias instance) {
        this(instance, (Boolean)true);
    }

    public HostAliasBuilder(HostAlias instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public HostAliasBuilder(Validator validator) {
        this(new HostAlias(), (Boolean)true);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, HostAlias instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHostnames(instance.getHostnames());
        fluent.withIp(instance.getIp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HostAliasBuilder(HostAlias instance, Validator validator) {
        this.fluent = this;
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public HostAlias build() {
        HostAlias buildable = new HostAlias(this.fluent.getHostnames(), this.fluent.getIp());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostAliasBuilder that = (HostAliasBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

