/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.ResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.ResourceMetricSourceFluentImpl;
import javax.validation.Validator;

public class ResourceMetricSourceBuilder
extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder>
implements VisitableBuilder<ResourceMetricSource, ResourceMetricSourceBuilder> {
    ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceMetricSourceBuilder() {
        this(true);
    }

    public ResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance) {
        this(fluent, instance, true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance) {
        this(instance, (Boolean)true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSourceBuilder(Validator validator) {
        this(new ResourceMetricSource(), (Boolean)true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(this.fluent.getName(), this.fluent.getTargetAverageUtilization(), this.fluent.getTargetAverageValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceBuilder that = (ResourceMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

