/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Squash {
    private final String branch;
    private final GitImpl git;
    private String squashedCommitMessage;
    private String startCommitString;

    public Squash(GitImpl git, String branch, String startCommitString, String squashedCommitMessage) {
        this.git = git;
        this.squashedCommitMessage = squashedCommitMessage;
        this.branch = branch;
        this.startCommitString = startCommitString;
    }

    public void execute() {
        RevCommit startCommit;
        Repository repo = this.git.getRepository();
        RevCommit latestCommit = this.git.getLastCommit(this.branch);
        RevCommit parent = startCommit = this.checkIfCommitIsPresentAtBranch(this.git, this.branch, this.startCommitString);
        if (startCommit.getParentCount() > 0) {
            parent = startCommit.getParent(0);
        }
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setParentId((AnyObjectId)parent);
        commitBuilder.setTreeId((AnyObjectId)latestCommit.getTree().getId());
        commitBuilder.setMessage(this.squashedCommitMessage);
        commitBuilder.setAuthor(startCommit.getAuthorIdent());
        commitBuilder.setCommitter(startCommit.getAuthorIdent());
        try (ObjectInserter odi = repo.newObjectInserter();){
            RevCommit squashedCommit = this.git.resolveRevCommit(odi.insert(commitBuilder));
            this.git.refUpdate(this.branch, squashedCommit);
        }
        catch (IOException | ConcurrentRefUpdateException e) {
            throw new GitException("Error on executing squash.", e);
        }
    }

    private RevCommit checkIfCommitIsPresentAtBranch(GitImpl git, String branch, String startCommitString) {
        try {
            ObjectId id = git.getRef(branch).getObjectId();
            Spliterator log = git._log().add((AnyObjectId)id).call().spliterator();
            return StreamSupport.stream(log, false).filter(elem -> elem.getName().equals(startCommitString)).findFirst().orElseThrow(() -> new GitException("Commit is not present at branch " + branch));
        }
        catch (GitAPIException | IncorrectObjectTypeException | MissingObjectException e) {
            throw new GitException("A problem occurred when trying to get commit list", e);
        }
    }
}

