/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringMapPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindRuleFlowNamesQuery
extends AbstractFindQuery
implements NamedQuery {
    private static final Logger logger = LoggerFactory.getLogger(FindRuleFlowNamesQuery.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private RuleFlowNamesResponseBuilder responseBuilder = new RuleFlowNamesResponseBuilder();
    public static final String NAME = FindRuleFlowNamesQuery.class.getSimpleName();
    private static final ValueSharedPartIndexTerm ruleFlowTerm = new ValueSharedPartIndexTerm("not-used", PartType.RULEFLOW_GROUP);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        this.responseBuilder.setIOService(this.ioService);
        return this.responseBuilder;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        return this.buildFromSingleTerm(terms);
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{null, null, ruleFlowTerm.getTerm()}, t -> t instanceof ValueModuleNameIndexTerm, t -> t instanceof ValueBranchNameIndexTerm, t -> t.getTerm().equals(ruleFlowTerm.getTerm()));
    }

    private static class RuleFlowNamesResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;

        private RuleFlowNamesResponseBuilder() {
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        @Override
        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        @Override
        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            for (KObject kObject : kObjects) {
                Map<String, Map<String, String>> ruleFlowGroupNames = this.getRuleFlowGroupNamesNamesFromKObject(kObject);
                for (String rkey : ruleFlowGroupNames.keySet()) {
                    RefactoringMapPageRow row = new RefactoringMapPageRow();
                    row.setValue(ruleFlowGroupNames.get(rkey));
                    result.add((RefactoringPageRow)row);
                }
            }
            return result;
        }

        private Map<String, Map<String, String>> getRuleFlowGroupNamesNamesFromKObject(KObject kObject) {
            HashMap<String, Map<String, String>> ruleFlowGroupNames = new HashMap<String, Map<String, String>>();
            if (kObject == null) {
                return ruleFlowGroupNames;
            }
            for (KProperty property : kObject.getProperties()) {
                org.uberfire.backend.vfs.Path path;
                if (!property.getName().equals("shared:" + PartType.RULEFLOW_GROUP.toString())) continue;
                if (ruleFlowGroupNames.containsKey(property.getValue().toString())) {
                    path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                    ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("name", property.getValue().toString());
                    ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("filename", path.getFileName());
                    ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("pathuri", path.toURI());
                    continue;
                }
                path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                ruleFlowGroupNames.put(property.getValue().toString(), new HashMap());
                ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("name", property.getValue().toString());
                ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("filename", path.getFileName());
                ((Map)ruleFlowGroupNames.get(property.getValue().toString())).put("pathuri", path.toURI());
            }
            return ruleFlowGroupNames;
        }
    }
}

