/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionFluent;

public class TCPSocketActionFluentImpl<A extends TCPSocketActionFluent<A>>
extends BaseFluent<A>
implements TCPSocketActionFluent<A> {
    private String host;
    private IntOrStringBuilder port;

    public TCPSocketActionFluentImpl() {
    }

    public TCPSocketActionFluentImpl(TCPSocketAction instance) {
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public A withNewHost(String arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    public A withNewHost(StringBuilder arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    public A withNewHost(StringBuffer arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String strVal) {
        return this.withPort(new IntOrString(strVal));
    }

    @Override
    public A withNewPort(Integer intVal) {
        return this.withPort(new IntOrString(intVal));
    }

    @Override
    public TCPSocketActionFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public TCPSocketActionFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public TCPSocketActionFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public TCPSocketActionFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public TCPSocketActionFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPSocketActionFluentImpl that = (TCPSocketActionFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public class PortNestedImpl<N>
    extends IntOrStringFluentImpl<TCPSocketActionFluent.PortNested<N>>
    implements TCPSocketActionFluent.PortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)TCPSocketActionFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

