/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.UnDeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.service.AbstractDefEditorService;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.events.DeleteDriverEvent;
import org.kie.workbench.common.screens.datasource.management.events.NewDriverEvent;
import org.kie.workbench.common.screens.datasource.management.events.UpdateDriverEvent;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDefEditorContent;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.service.DriverDefEditorService;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefSerializer;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.io.IOService;

@Service
@ApplicationScoped
public class DriverDefEditorServiceImpl
extends AbstractDefEditorService<DriverDefEditorContent, DriverDef, DriverDeploymentInfo>
implements DriverDefEditorService {
    private Event<NewDriverEvent> newDriverEvent;
    private Event<UpdateDriverEvent> updateDriverEvent;
    private Event<DeleteDriverEvent> deleteDriverEvent;

    public DriverDefEditorServiceImpl() {
    }

    @Inject
    public DriverDefEditorServiceImpl(DataSourceRuntimeManager runtimeManager, DataSourceServicesHelper serviceHelper, @Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, CommentedOptionFactory optionsFactory, PathNamingService pathNamingService, MavenArtifactResolver artifactResolver, Event<NewDriverEvent> newDriverEvent, Event<UpdateDriverEvent> updateDriverEvent, Event<DeleteDriverEvent> deleteDriverEvent) {
        super(runtimeManager, serviceHelper, ioService, moduleService, optionsFactory, pathNamingService, artifactResolver);
        this.newDriverEvent = newDriverEvent;
        this.updateDriverEvent = updateDriverEvent;
        this.deleteDriverEvent = deleteDriverEvent;
    }

    @Override
    protected DriverDefEditorContent newContent() {
        return new DriverDefEditorContent();
    }

    @Override
    protected DriverDef deserializeDef(String source) {
        return DriverDefSerializer.deserialize(source);
    }

    @Override
    protected DriverDeploymentInfo readDeploymentInfo(String uuid) throws Exception {
        return this.runtimeManager.getDriverDeploymentInfo(uuid);
    }

    @Override
    protected String serializeDef(DriverDef def) {
        return DriverDefSerializer.serialize(def);
    }

    @Override
    protected void unDeploy(DriverDeploymentInfo deploymentInfo, UnDeploymentOptions options) throws Exception {
        this.runtimeManager.unDeployDriver(deploymentInfo, options);
    }

    @Override
    protected void deploy(DriverDef def, DeploymentOptions options) throws Exception {
        this.runtimeManager.deployDriver(def, options);
    }

    @Override
    protected void fireCreateEvent(DriverDef def, Module module) {
        this.newDriverEvent.fire((Object)new NewDriverEvent(def, module, this.optionsFactory.getSafeSessionId(), this.optionsFactory.getSafeIdentityName()));
    }

    @Override
    protected void fireCreateEvent(DriverDef def) {
        this.newDriverEvent.fire((Object)new NewDriverEvent(def, this.optionsFactory.getSafeSessionId(), this.optionsFactory.getSafeIdentityName()));
    }

    @Override
    protected void fireUpdateEvent(DriverDef def, Module module, DriverDef originalDef) {
        this.updateDriverEvent.fire((Object)new UpdateDriverEvent(def, module, this.optionsFactory.getSafeSessionId(), this.optionsFactory.getSafeIdentityName(), originalDef));
    }

    @Override
    protected void fireDeleteEvent(DriverDef def, Module module) {
        this.deleteDriverEvent.fire((Object)new DeleteDriverEvent(def, module, this.optionsFactory.getSafeSessionId(), this.optionsFactory.getSafeIdentityName()));
    }

    @Override
    protected String buildFileName(DriverDef def) {
        return def.getName() + ".driver";
    }

    @Override
    protected Path create(DriverDef driverDef, Path context) {
        try {
            this.validateDriver(driverDef);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return super.create(driverDef, context);
    }

    public List<ValidationMessage> validate(DriverDef driverDef) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        try {
            this.validateDriver(driverDef);
        }
        catch (Exception e) {
            ValidationMessage message = new ValidationMessage();
            message.setLevel(Level.ERROR);
            message.setText(e.getMessage());
            messages.add(message);
        }
        return messages;
    }

    private void validateDriver(DriverDef driverDef) throws Exception {
        URI uri = this.artifactResolver.resolve(driverDef.getGroupId(), driverDef.getArtifactId(), driverDef.getVersion());
        if (uri == null) {
            throw new Exception("maven artifact was not found: " + driverDef.getGroupId() + ":" + driverDef.getArtifactId() + ":" + driverDef.getVersion());
        }
        URL[] urls = new URL[]{uri.toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls);
        try {
            Class<?> driverClass = classLoader.loadClass(driverDef.getDriverClass());
            if (!Driver.class.isAssignableFrom(driverClass)) {
                throw new Exception("class: " + driverDef.getDriverClass() + " do not extend from: " + Driver.class.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new Exception("driver class: " + driverDef.getDriverClass() + " was not found in current gav");
        }
    }
}

