/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.CoreCondition;
import org.dashbuilder.dataprovider.sql.model.LogicalCondition;
import org.dashbuilder.dataprovider.sql.model.Table;

public class SQLStatement<T extends SQLStatement> {
    protected Connection connection;
    protected Dialect dialect;
    protected Table table = null;
    protected Set<Column> _columnsRefs = new HashSet<Column>();

    public SQLStatement(Connection connection, Dialect dialect) {
        this.connection = connection;
        this.dialect = dialect;
    }

    public T table(Table table) {
        this.table = this.fix(table);
        return (T)this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Table getTable() {
        return this.table;
    }

    protected Table fix(Table table) {
        String name = this.fixCase(table.getName());
        table.setName(name);
        return table;
    }

    protected Column fix(Column column) {
        this._columnsRefs.add(column);
        return column;
    }

    protected Condition fix(Condition condition) {
        if (condition instanceof CoreCondition) {
            this.fix(((CoreCondition)condition).getColumn());
        }
        if (condition instanceof LogicalCondition) {
            for (Condition term : ((LogicalCondition)condition).getConditions()) {
                this.fix(term);
            }
        }
        return condition;
    }

    protected String fixCase(String id) {
        return id == null ? null : JDBCUtils.fixCase(this.connection, id);
    }

    protected void fixColumns() {
        for (Column column : this._columnsRefs) {
            String name = this.fixCase(column.getName());
            column.setName(name);
        }
    }
}

