/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Types;

public class ImportImpl
implements Import {
    private AST ast = null;
    private ImportDeclaration imprt = null;

    private void init(JavaSource<?> parent) {
        CompilationUnit cu = (CompilationUnit)parent.getInternal();
        this.ast = cu.getAST();
    }

    public ImportImpl(JavaSource<?> parent) {
        this.init(parent);
        this.imprt = this.ast.newImportDeclaration();
    }

    public ImportImpl(JavaSource<?> parent, Object internal) {
        this.init(parent);
        this.imprt = (ImportDeclaration)internal;
    }

    public String getSimpleName() {
        return Types.toSimpleName((String)this.imprt.getName().getFullyQualifiedName());
    }

    public String getQualifiedName() {
        return this.imprt.getName().getFullyQualifiedName();
    }

    public Import setName(String name) {
        if (name.endsWith(".*")) {
            this.imprt.setName(this.ast.newName(Types.tokenizeClassName((String)name.replaceAll("\\.\\*", ""))));
            this.imprt.setOnDemand(true);
        } else {
            this.imprt.setName(this.ast.newName(Types.tokenizeClassName((String)name)));
        }
        return this;
    }

    public boolean isStatic() {
        return this.imprt.isStatic();
    }

    public Import setStatic(boolean value) {
        this.imprt.setStatic(value);
        return this;
    }

    public boolean isWildcard() {
        return this.imprt.isOnDemand();
    }

    public Object getInternal() {
        return this.imprt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imprt == null ? 0 : this.imprt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Import)) {
            return false;
        }
        Import other = (Import)obj;
        return this.getQualifiedName().equals(other.getQualifiedName());
    }

    public String toString() {
        return "Import [" + this.getQualifiedName() + "]";
    }

    public String getPackage() {
        return Types.getPackage((String)this.getQualifiedName());
    }
}

