/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.FileTimeImpl;
import org.uberfire.java.nio.base.LazyAttrLoader;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.file.SimpleBasicFileAttributeView;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;

public class K8SBasicFileAttributeView
extends SimpleBasicFileAttributeView {
    private static final Logger logger = LoggerFactory.getLogger(K8SBasicFileAttributeView.class);
    private BasicFileAttributes attrs = null;
    private final CloudClientFactory ccf;

    public K8SBasicFileAttributeView(Path path, CloudClientFactory ccf) {
        super(path);
        this.ccf = ccf;
    }

    public <T extends BasicFileAttributes> T readAttributes() {
        if (this.attrs == null) {
            final ConfigMap fileCM = this.ccf.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, this.path), KubernetesClient.class).orElseThrow(() -> new NoSuchFileException(this.path.toRealPath(new LinkOption[0]).toString()));
            this.attrs = new BasicFileAttributesImpl(this.path.toString(), (FileTime)new FileTimeImpl(K8SFileSystemUtils.getLastModifiedTime(fileCM)), (FileTime)new FileTimeImpl(K8SFileSystemUtils.getCreationTime(fileCM)), null, (LazyAttrLoader)new LazyAttrLoader<Long>(){
                private Long size = null;

                public Long get() {
                    if (this.size == null) {
                        this.size = K8SFileSystemUtils.getSize(fileCM);
                    }
                    return this.size;
                }
            }, K8SFileSystemUtils.isFile(fileCM), K8SFileSystemUtils.isDirectory(fileCM));
        }
        return (T)this.attrs;
    }

    public void setAttribute(String attribute, Object value) {
        logger.debug("Not implemented");
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{BasicFileAttributeView.class, K8SBasicFileAttributeView.class};
    }
}

