/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.io.IOException;
import java.text.Format;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.i18n.LocaleTag;

public abstract class FormatTagSupport
extends TagSupport {
    protected static String _tagname = "i18n:";
    private Object value;
    private Locale locale;
    private String defaultText = "";

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            Object value = this.getValue();
            JspWriter out = this.pageContext.getOut();
            String text = null;
            if (value != null) {
                Format formatter = this.getFormat();
                if (formatter == null) {
                    throw new JspTagException(_tagname + " tag, could not find valid Format instance");
                }
                text = formatter.format(value);
            } else {
                text = this.getDefaultText();
            }
            if (text != null) {
                out.print(text);
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return 6;
    }

    public void release() {
        super.release();
        this.value = null;
        this.locale = null;
        this.defaultText = "";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return this.findLocale();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    protected abstract Format getFormat();

    protected void handleIOException(IOException e) throws JspException {
        this.pageContext.getServletContext().log("Caught: IOException: " + e);
        throw new JspTagException(_tagname + " tag, IOException: " + e);
    }

    private Locale findLocale() {
        LocaleTag localeTag = (LocaleTag)FormatTagSupport.findAncestorWithClass((Tag)this, LocaleTag.class);
        if (localeTag != null) {
            return localeTag.getLocale();
        }
        return this.pageContext.getResponse().getLocale();
    }

    protected int getStyleCode(String style) {
        if ("short".equalsIgnoreCase(style)) {
            return 3;
        }
        if ("medium".equalsIgnoreCase(style)) {
            return 2;
        }
        if ("long".equalsIgnoreCase(style)) {
            return 1;
        }
        if ("full".equalsIgnoreCase(style)) {
            return 0;
        }
        return 3;
    }
}

