/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.context;

import java.text.ParseException;
import java.util.List;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.CartesianDistCalc;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.distance.GeodesicSphereDistCalc;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.io.SupportedFormats;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class SpatialContext {
    public static final SpatialContext GEO = new SpatialContext(new SpatialContextFactory());
    private final boolean geo;
    private final ShapeFactory shapeFactory;
    private final DistanceCalculator calculator;
    private final Rectangle worldBounds;
    private final BinaryCodec binaryCodec;
    private final SupportedFormats formats;

    @Deprecated
    public SpatialContext(boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        this(SpatialContext.initFromLegacyConstructor(geo, calculator, worldBounds));
    }

    private static SpatialContextFactory initFromLegacyConstructor(boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        SpatialContextFactory factory = new SpatialContextFactory();
        factory.geo = geo;
        factory.distCalc = calculator;
        factory.worldBounds = worldBounds;
        return factory;
    }

    @Deprecated
    public SpatialContext(boolean geo) {
        this(SpatialContext.initFromLegacyConstructor(geo, null, null));
    }

    public SpatialContext(SpatialContextFactory factory) {
        this.geo = factory.geo;
        this.shapeFactory = factory.makeShapeFactory(this);
        this.calculator = factory.distCalc == null ? (this.isGeo() ? new GeodesicSphereDistCalc.Haversine() : new CartesianDistCalc()) : factory.distCalc;
        Rectangle bounds = factory.worldBounds;
        if (bounds == null) {
            this.worldBounds = this.isGeo() ? new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this) : new RectangleImpl(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, this);
        } else {
            if (this.isGeo() && !bounds.equals(new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this))) {
                throw new IllegalArgumentException("for geo (lat/lon), bounds must be " + GEO.getWorldBounds());
            }
            if (bounds.getMinX() > bounds.getMaxX()) {
                throw new IllegalArgumentException("worldBounds minX should be <= maxX: " + bounds);
            }
            if (bounds.getMinY() > bounds.getMaxY()) {
                throw new IllegalArgumentException("worldBounds minY should be <= maxY: " + bounds);
            }
            this.worldBounds = new RectangleImpl(bounds, this);
        }
        this.binaryCodec = factory.makeBinaryCodec(this);
        factory.checkDefaultFormats();
        this.formats = factory.makeFormats(this);
    }

    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public SupportedFormats getFormats() {
        return this.formats;
    }

    public DistanceCalculator getDistCalc() {
        return this.calculator;
    }

    public double calcDistance(Point p, double x2, double y2) {
        return this.getDistCalc().distance(p, x2, y2);
    }

    public double calcDistance(Point p, Point p2) {
        return this.getDistCalc().distance(p, p2);
    }

    public Rectangle getWorldBounds() {
        return this.worldBounds;
    }

    @Deprecated
    public boolean isNormWrapLongitude() {
        return this.shapeFactory.isNormWrapLongitude();
    }

    public boolean isGeo() {
        return this.geo;
    }

    @Deprecated
    public double normX(double x) {
        return this.shapeFactory.normX(x);
    }

    @Deprecated
    public double normY(double y) {
        return this.shapeFactory.normY(y);
    }

    @Deprecated
    public void verifyX(double x) {
        this.shapeFactory.verifyX(x);
    }

    @Deprecated
    public void verifyY(double y) {
        this.shapeFactory.verifyY(y);
    }

    @Deprecated
    public Point makePoint(double x, double y) {
        return this.shapeFactory.pointXY(x, y);
    }

    @Deprecated
    public Rectangle makeRectangle(Point lowerLeft, Point upperRight) {
        return this.shapeFactory.rect(lowerLeft, upperRight);
    }

    @Deprecated
    public Rectangle makeRectangle(double minX, double maxX, double minY, double maxY) {
        return this.shapeFactory.rect(minX, maxX, minY, maxY);
    }

    @Deprecated
    public Circle makeCircle(double x, double y, double distance) {
        return this.shapeFactory.circle(x, y, distance);
    }

    @Deprecated
    public Circle makeCircle(Point point, double distance) {
        return this.shapeFactory.circle(point, distance);
    }

    @Deprecated
    public Shape makeLineString(List<Point> points) {
        return this.shapeFactory.lineString(points, 0.0);
    }

    @Deprecated
    public Shape makeBufferedLineString(List<Point> points, double buf) {
        return this.shapeFactory.lineString(points, buf);
    }

    @Deprecated
    public <S extends Shape> ShapeCollection<S> makeCollection(List<S> coll) {
        return this.shapeFactory.multiShape(coll);
    }

    @Deprecated
    public WKTReader getWktShapeParser() {
        return (WKTReader)this.formats.getWktReader();
    }

    @Deprecated
    public Shape readShapeFromWkt(String wkt) throws ParseException, InvalidShapeException {
        return this.getWktShapeParser().parse(wkt);
    }

    public BinaryCodec getBinaryCodec() {
        return this.binaryCodec;
    }

    @Deprecated
    public Shape readShape(String value) throws InvalidShapeException {
        return this.formats.read(value);
    }

    @Deprecated
    public String toString(Shape shape) {
        return LegacyShapeWriter.writeShape(shape);
    }

    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return this.getClass().getSimpleName() + "{" + "geo=" + this.geo + ", calculator=" + this.calculator + ", worldBounds=" + this.worldBounds + '}';
    }
}

