/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerUserAuthServiceFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager,
Closeable {
    public static final Factory<SshServer> DEFAULT_SSH_SERVER_FACTORY = SshServer::new;
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ServerUserAuthServiceFactory.INSTANCE, ServerConnectionServiceFactory.INSTANCE));
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    private ServerProxyAcceptor proxyAcceptor;
    private Factory<Command> shellFactory;
    private SessionFactory sessionFactory;
    private CommandFactory commandFactory;
    private List<NamedFactory<Command>> subsystemFactories;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private GSSAuthenticator gssAuthenticator;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public Factory<Command> getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(Factory<Command> shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.proxyAcceptor;
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor proxyAcceptor) {
        this.proxyAcceptor = proxyAcceptor;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List<NamedFactory<Command>> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<NamedFactory<Command>> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        return this.interactiveAuthenticator;
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator interactiveAuthenticator) {
        this.interactiveAuthenticator = interactiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        return this.hostBasedAuthenticator;
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public void setTcpipForwardingFilter(ForwardingFilter forwardingFilter) {
        this.tcpipForwardingFilter = forwardingFilter;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkTrue(this.getPort() >= 0, "Bad port number: %d", (Object)this.getPort());
        List<NamedFactory<UserAuth>> authFactories = ServerAuthenticationManager.resolveUserAuthFactories(this);
        this.setUserAuthFactories(ValidateUtils.checkNotNullAndNotEmpty(authFactories, "UserAuthFactories not set", new Object[0]));
        ValidateUtils.checkNotNullAndNotEmpty(this.getChannelFactories(), "ChannelFactories not set", new Object[0]);
        Objects.requireNonNull(this.getKeyPairProvider(), "HostKeyProvider not set");
        Objects.requireNonNull(this.getFileSystemFactory(), "FileSystemFactory not set");
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        String hostsList = this.getHost();
        if (!GenericUtils.isEmpty(hostsList)) {
            String[] hosts;
            for (String host : hosts = GenericUtils.split(hostsList, ',')) {
                InetAddress[] inetAddresses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("start() - resolve bind host={}", (Object)host);
                }
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("start() - bind host={} / {}", (Object)host, (Object)inetAddress);
                    }
                    this.acceptor.bind(new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                    this.log.info("start() listen on auto-allocated port=" + this.port);
                }
            }
        } else {
            this.acceptor.bind(new InetSocketAddress(this.port));
            if (this.port == 0) {
                this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                this.log.info("start() listen on auto-allocated port=" + this.port);
            }
        }
    }

    public void stop() throws IOException {
        this.stop(false);
    }

    public void stop(boolean immediately) throws IOException {
        long maxWait = immediately ? this.getLongProperty("stop-wait-time", DEFAULT_STOP_WAIT_TIME) : Long.MAX_VALUE;
        boolean successful = this.close(immediately).await(maxWait);
        if (!successful) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(() -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.acceptor, this.ioServiceFactory).run(() -> {
            this.acceptor = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        IoServiceFactory ioFactory = this.getIoServiceFactory();
        SessionFactory sessFactory = this.getSessionFactory();
        return ioFactory.createAcceptor(sessFactory);
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return "SshServer[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshServer setUpDefaultServer() {
        return (SshServer)ServerBuilder.builder().build();
    }

    public static KeyPairProvider setupServerKeys(SshServer sshd, String hostKeyType, int hostKeySize, Collection<String> keyFiles) throws Exception {
        if (GenericUtils.isEmpty(keyFiles)) {
            List keys;
            KeyPair kp;
            PublicKey pubKey;
            String keyAlgorithm;
            AbstractGeneratorHostKeyProvider hostKeyProvider;
            Path hostKeyFile;
            if (SecurityUtils.isBouncyCastleRegistered()) {
                hostKeyFile = new File("key.pem").toPath();
                hostKeyProvider = SecurityUtils.createGeneratorHostKeyProvider(hostKeyFile);
            } else {
                hostKeyFile = new File("key.ser").toPath();
                hostKeyProvider = new SimpleGeneratorHostKeyProvider(hostKeyFile);
            }
            hostKeyProvider.setAlgorithm(hostKeyType);
            if (hostKeySize != 0) {
                hostKeyProvider.setKeySize(hostKeySize);
            }
            if ("ECDSA".equalsIgnoreCase(keyAlgorithm = (pubKey = (kp = (KeyPair)(keys = (List)ValidateUtils.checkNotNullAndNotEmpty(hostKeyProvider.loadKeys(), "Failed to load keys from %s", hostKeyFile)).get(0)).getPublic()).getAlgorithm())) {
                keyAlgorithm = "EC";
            } else if ("ED25519".equals(keyAlgorithm)) {
                keyAlgorithm = "EdDSA";
            }
            if (!Objects.equals(keyAlgorithm, hostKeyType)) {
                Files.deleteIfExists(hostKeyFile);
                hostKeyProvider.clearLoadedKeys();
            }
            return hostKeyProvider;
        }
        ArrayList<KeyPair> pairs = new ArrayList<KeyPair>(keyFiles.size());
        for (String keyFilePath : keyFiles) {
            Path path = Paths.get(keyFilePath, new String[0]);
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    KeyPair kp = SecurityUtils.loadKeyPairIdentity(keyFilePath, inputStream, null);
                    pairs.add(kp);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {
                System.err.append("Failed (" + e.getClass().getSimpleName() + ")" + " to load host key file=" + keyFilePath + ": " + e.getMessage());
                throw e;
            }
        }
        return new MappedKeyPairProvider(pairs);
    }

    public static void main(String[] args) throws Exception {
        int port = 8000;
        boolean error = false;
        String hostKeyType = "RSA";
        int hostKeySize = 0;
        LinkedList<String> keyFiles = null;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        int numArgs = GenericUtils.length(args);
        for (int i = 0; i < numArgs; ++i) {
            String argName = args[i];
            if ("-p".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-key-type".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (keyFiles != null) {
                    System.err.println("option conflicts with -key-file: " + argName);
                    error = true;
                    break;
                }
                hostKeyType = args[++i].toUpperCase();
                continue;
            }
            if ("-key-size".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (keyFiles != null) {
                    System.err.println("option conflicts with -key-file: " + argName);
                    error = true;
                    break;
                }
                hostKeySize = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-key-file".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                String keyFilePath = args[++i];
                if (keyFiles == null) {
                    keyFiles = new LinkedList<String>();
                }
                keyFiles.add(keyFilePath);
                continue;
            }
            if ("-io".equals(argName)) {
                String provider;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if ("mina".equals(provider = args[++i])) {
                    System.setProperty(IoServiceFactory.class.getName(), MinaServiceFactory.class.getName());
                    continue;
                }
                if ("nio2".endsWith(provider)) {
                    System.setProperty(IoServiceFactory.class.getName(), Nio2ServiceFactory.class.getName());
                    continue;
                }
                System.err.println("provider should be mina or nio2: " + argName);
                error = true;
                break;
            }
            if ("-o".equals(argName)) {
                String opt;
                int idx;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires and argument: " + argName);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    System.err.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if (argName.startsWith("-")) {
                System.err.println("illegal option: " + argName);
                error = true;
                break;
            }
            System.err.println("extra argument: " + argName);
            error = true;
            break;
        }
        if (error) {
            System.err.println("usage: sshd [-p port] [-io mina|nio2] [-key-type RSA|DSA|EC] [-key-size NNNN] [-key-file <path>] [-o option=value]");
            System.exit(-1);
        }
        System.err.println("Starting SSHD on port " + port);
        SshServer sshd = SshServer.setUpDefaultServer();
        Map<String, Object> props = sshd.getProperties();
        props.putAll(options);
        KeyPairProvider hostKeyProvider = SshServer.setupServerKeys(sshd, hostKeyType, hostKeySize, keyFiles);
        sshd.setKeyPairProvider(hostKeyProvider);
        SshServer.setupServerBanner(sshd, options);
        sshd.setPort(port);
        sshd.setShellFactory(InteractiveProcessShellFactory.INSTANCE);
        sshd.setPasswordAuthenticator((username, password, session) -> Objects.equals(username, password));
        sshd.setPublickeyAuthenticator(AcceptAllPublickeyAuthenticator.INSTANCE);
        sshd.setTcpipForwardingFilter(AcceptAllForwardingFilter.INSTANCE);
        sshd.setCommandFactory(new ScpCommandFactory.Builder().withDelegate(command -> new ProcessShellFactory(GenericUtils.split(command, ' ')).create()).build());
        sshd.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        sshd.start();
        Thread.sleep(Long.MAX_VALUE);
    }

    public static Object setupServerBanner(ServerFactoryManager server, Map<String, ?> options) throws Exception {
        Object banner;
        String bannerOption;
        String string = bannerOption = GenericUtils.isEmpty(options) ? null : Objects.toString(options.remove("Banner"), null);
        if (GenericUtils.isEmpty(bannerOption)) {
            String string2 = bannerOption = GenericUtils.isEmpty(options) ? null : Objects.toString(options.remove("VisualHostKey"), null);
            if (SshConfigFileReader.parseBooleanValue(bannerOption)) {
                bannerOption = "#auto-welcome-banner";
            }
        }
        if (GenericUtils.isNotEmpty(bannerOption)) {
            if ("none".equals(bannerOption)) {
                return null;
            }
            banner = "#auto-welcome-banner".equalsIgnoreCase(bannerOption) ? bannerOption : Paths.get(bannerOption, new String[0]);
        } else {
            banner = "Welcome to SSHD\n";
        }
        PropertyResolverUtils.updateProperty((PropertyResolver)server, "welcome-banner", banner);
        return banner;
    }
}

