/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaEnum;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;

public class DataModelImpl
implements DataModel {
    Map<String, DataObject> dataObjects = new HashMap<String, DataObject>();
    Map<String, DataObject> dependencyDataObjects = new HashMap<String, DataObject>();
    Map<String, JavaEnum> javaEnums = new HashMap<String, JavaEnum>();
    Map<String, JavaEnum> dependencyJavaEnums = new HashMap<String, JavaEnum>();

    @Override
    public Set<DataObject> getDataObjects() {
        return this.getDataObjects(ObjectSource.INTERNAL);
    }

    @Override
    public Set<DataObject> getDataObjects(ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.getDataObjects(this.dataObjects);
            }
            case DEPENDENCY: {
                return this.getDataObjects(this.dependencyDataObjects);
            }
        }
        return null;
    }

    @Override
    public DataObject getDataObject(String className) {
        return this.getDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject getDataObject(String className, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.dataObjects.get(className);
            }
            case DEPENDENCY: {
                return this.dependencyDataObjects.get(className);
            }
        }
        return null;
    }

    @Override
    public DataObject removeDataObject(String className) {
        return this.removeDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject removeDataObject(String className, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.dataObjects.remove(className);
            }
            case DEPENDENCY: {
                return this.dependencyDataObjects.remove(className);
            }
        }
        return null;
    }

    @Override
    public DataObject addDataObject(String packageName, String name) {
        return this.addDataObject(packageName, name, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String className) {
        return this.addDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String className, ObjectSource source) {
        return this.addDataObject(className, Visibility.PUBLIC, false, false, source);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, ObjectSource source) {
        return this.addDataObject(packageName, name, Visibility.PUBLIC, false, false, source);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, Visibility visibility) {
        return this.addDataObject(packageName, name, visibility, false, false, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal) {
        return this.addDataObject(packageName, name, visibility, isAbstract, isFinal, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String className, Visibility visibility, boolean isAbstract, boolean isFinal) {
        return this.addDataObject(className, visibility, isAbstract, isFinal, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String className, Visibility visibility, boolean isAbstract, boolean isFinal, ObjectSource source) {
        String name = NamingUtils.extractClassName(className);
        String packageName = NamingUtils.extractPackageName(className);
        return this.addDataObject(packageName, name, visibility, isAbstract, isFinal, source);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.addDataObject(packageName, name, visibility, isAbstract, isFinal, this.dataObjects);
            }
            case DEPENDENCY: {
                return this.addDataObject(packageName, name, visibility, isAbstract, isFinal, this.dependencyDataObjects);
            }
        }
        return null;
    }

    private Set<DataObject> getDataObjects(Map<String, DataObject> objectsMap) {
        HashSet<DataObject> set = new HashSet<DataObject>();
        set.addAll(objectsMap.values());
        return set;
    }

    private DataObject addDataObject(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal, Map<String, DataObject> objectsMap) {
        DataObjectImpl dataObject = new DataObjectImpl(packageName, name, visibility, isAbstract, isFinal);
        objectsMap.put(dataObject.getClassName(), dataObject);
        return dataObject;
    }

    @Override
    public DataObject addDataObject(DataObject dataObject) {
        this.dataObjects.put(dataObject.getClassName(), dataObject);
        return dataObject;
    }

    @Override
    public List<DataObject> getExternalClasses() {
        ArrayList<DataObject> result = new ArrayList<DataObject>();
        result.addAll(this.dependencyDataObjects.values());
        return result;
    }

    @Override
    public JavaEnum addJavaEnum(JavaEnum javaEnum) {
        return this.addJavaEnum(javaEnum, ObjectSource.INTERNAL);
    }

    @Override
    public JavaEnum addJavaEnum(JavaEnum javaEnum, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                this.javaEnums.put(javaEnum.getClassName(), javaEnum);
                break;
            }
            case DEPENDENCY: {
                this.dependencyJavaEnums.put(javaEnum.getClassName(), javaEnum);
            }
        }
        return javaEnum;
    }

    @Override
    public JavaEnum removeJavaEnum(String className) {
        return this.javaEnums.remove(className);
    }

    @Override
    public JavaEnum getJavaEnum(String className) {
        return this.javaEnums.get(className);
    }

    @Override
    public List<JavaEnum> getJavaEnums() {
        ArrayList<JavaEnum> result = new ArrayList<JavaEnum>();
        result.addAll(this.javaEnums.values());
        return result;
    }

    @Override
    public List<JavaEnum> getDependencyJavaEnums() {
        ArrayList<JavaEnum> result = new ArrayList<JavaEnum>();
        result.addAll(this.dependencyJavaEnums.values());
        return result;
    }

    @Override
    public boolean isExternal(String className) {
        return this.dependencyDataObjects.containsKey(className);
    }

    @Override
    public boolean isEnum(String className) {
        return this.javaEnums.containsKey(className) || this.dependencyJavaEnums.containsKey(className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelImpl dataModel = (DataModelImpl)o;
        if (this.dataObjects != null ? !this.dataObjects.equals(dataModel.dataObjects) : dataModel.dataObjects != null) {
            return false;
        }
        if (this.dependencyDataObjects != null ? !this.dependencyDataObjects.equals(dataModel.dependencyDataObjects) : dataModel.dependencyDataObjects != null) {
            return false;
        }
        if (this.javaEnums != null ? !this.javaEnums.equals(dataModel.javaEnums) : dataModel.javaEnums != null) {
            return false;
        }
        return this.dependencyJavaEnums != null ? this.dependencyJavaEnums.equals(dataModel.dependencyJavaEnums) : dataModel.dependencyJavaEnums == null;
    }

    public int hashCode() {
        int result = this.dataObjects != null ? this.dataObjects.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.dependencyDataObjects != null ? this.dependencyDataObjects.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.javaEnums != null ? this.javaEnums.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.dependencyJavaEnums != null ? this.dependencyJavaEnums.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

