/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser;

import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassOrInterfaceTypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.EllipsisParameterDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasClassOrInterfaceType;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasModifiers;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasPrimitiveType;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasType;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasTypeArguments;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierWithTypeArgumentsDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ImportDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.MethodDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.NormalParameterDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.PackageDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ParameterDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ParameterListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.QualifiedNameDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserBase
extends Parser {
    private static final Logger logger = LoggerFactory.getLogger(JavaParserBase.class);
    protected FileDescr fileDescr = new FileDescr();
    protected MethodDescr methodDescr;
    protected FieldDescr fieldDescr;
    protected Stack<ElementDescriptor> context = new Stack();
    protected boolean declaringMethodReturnType = false;
    protected boolean declaringSuperClass = false;
    protected int classLevel = 0;
    protected ParserMode mode = ParserMode.PARSE_CLASS;
    protected StringBuilder sourceBuffer;

    public JavaParserBase(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public FileDescr getFileDescr() {
        return this.fileDescr;
    }

    public ParserMode getMode() {
        return this.mode;
    }

    public MethodDescr getMethodDescr() {
        return this.methodDescr;
    }

    public FieldDescr getFieldDescr() {
        return this.fieldDescr;
    }

    public void setMode(ParserMode mode) {
        this.mode = mode;
    }

    public StringBuilder getSourceBuffer() {
        return this.sourceBuffer;
    }

    public void setSourceBuffer(StringBuilder sourceBuffer) {
        this.sourceBuffer = sourceBuffer;
    }

    private ClassDescr getClassDescr() {
        return this.fileDescr.getClassDescr();
    }

    protected void initContext() {
        this.context.push(this.fileDescr);
        if (this.sourceBuffer != null && this.sourceBuffer.length() > 0) {
            this.fileDescr.setStop(this.sourceBuffer.length() - 1);
        }
    }

    protected void log(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    protected boolean isFieldOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.FIELD);
    }

    protected boolean isMethodOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.METHOD);
    }

    protected boolean isTypeOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.TYPE);
    }

    protected boolean isClassOrInterfaceTypeOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.CLASS_OR_INTERFACE_TYPE);
    }

    protected boolean isTypeArgumentOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.TYPE_ARGUMENT);
    }

    protected boolean isParameterOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.NORMAL_PARAMETER) || this.isOnTop(ElementDescriptor.ElementType.ELLIPSIS_PARAMETER);
    }

    protected boolean isNormalParameterOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.NORMAL_PARAMETER);
    }

    protected boolean isEllipsisParameterOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.ELLIPSIS_PARAMETER);
    }

    protected boolean isModifierListOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.MODIFIER_LIST);
    }

    protected boolean isClassOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.CLASS);
    }

    protected boolean isFileOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.FILE);
    }

    protected boolean isQualifiedNameOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.QUALIFIED_NAME);
    }

    protected boolean isPackageOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.PACKAGE);
    }

    protected boolean isImportOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.IMPORT);
    }

    protected boolean isIdentifierWithTypeArgumentsOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.IDENTIFIER_WITH_TYPE_ARGUMENTS);
    }

    protected boolean isTypeArgumentListOnTop() {
        return this.isOnTop(ElementDescriptor.ElementType.TYPE_ARGUMENT_LIST);
    }

    protected boolean isOnTop(ElementDescriptor.ElementType elementType) {
        return !this.context.empty() && this.context.peek().isElementType(elementType);
    }

    protected MethodDescr popMethod() {
        return this.isMethodOnTop() ? (MethodDescr)this.context.pop() : null;
    }

    protected MethodDescr peekMethod() {
        return this.isMethodOnTop() ? (MethodDescr)this.context.peek() : null;
    }

    protected FieldDescr popField() {
        return this.isFieldOnTop() ? (FieldDescr)this.context.pop() : null;
    }

    protected FieldDescr peekField() {
        return this.isFieldOnTop() ? (FieldDescr)this.context.peek() : null;
    }

    protected TypeDescr popType() {
        return this.isTypeOnTop() ? (TypeDescr)this.context.pop() : null;
    }

    protected TypeDescr peekType() {
        return this.isTypeOnTop() ? (TypeDescr)this.context.peek() : null;
    }

    protected ClassOrInterfaceTypeDescr popClassOrInterfaceType() {
        return this.isClassOrInterfaceTypeOnTop() ? (ClassOrInterfaceTypeDescr)this.context.pop() : null;
    }

    protected ClassOrInterfaceTypeDescr peekClassOrInterfaceType() {
        return this.isClassOrInterfaceTypeOnTop() ? (ClassOrInterfaceTypeDescr)this.context.peek() : null;
    }

    protected TypeArgumentDescr popTypeArgument() {
        return this.isTypeArgumentOnTop() ? (TypeArgumentDescr)this.context.pop() : null;
    }

    protected ParameterDescr popParameter() {
        return this.isParameterOnTop() ? (ParameterDescr)this.context.pop() : null;
    }

    protected ParameterDescr peekParameter() {
        return this.isParameterOnTop() ? (ParameterDescr)this.context.peek() : null;
    }

    protected NormalParameterDescr popNormalParameter() {
        return this.isNormalParameterOnTop() ? (NormalParameterDescr)this.context.pop() : null;
    }

    protected NormalParameterDescr peekNormalParameter() {
        return this.isNormalParameterOnTop() ? (NormalParameterDescr)this.context.peek() : null;
    }

    protected EllipsisParameterDescr popEllipsisParameter() {
        return this.isEllipsisParameterOnTop() ? (EllipsisParameterDescr)this.context.pop() : null;
    }

    protected EllipsisParameterDescr peekEllipsisParameter() {
        return this.isEllipsisParameterOnTop() ? (EllipsisParameterDescr)this.context.peek() : null;
    }

    protected TypeArgumentListDescr popTypeArgumentList() {
        return this.isTypeArgumentListOnTop() ? (TypeArgumentListDescr)this.context.pop() : null;
    }

    protected TypeArgumentListDescr peekTypeArgumentList() {
        return this.isTypeArgumentListOnTop() ? (TypeArgumentListDescr)this.context.peek() : null;
    }

    protected ModifierListDescr popModifierList() {
        return this.isModifierListOnTop() ? (ModifierListDescr)this.context.pop() : null;
    }

    protected ModifierListDescr peekModifierList() {
        return this.isModifierListOnTop() ? (ModifierListDescr)this.context.peek() : null;
    }

    protected ClassDescr popClass() {
        return this.isClassOnTop() ? (ClassDescr)this.context.pop() : null;
    }

    protected ClassDescr peekClass() {
        return this.isClassOnTop() ? (ClassDescr)this.context.peek() : null;
    }

    protected FileDescr popFile() {
        return this.isFileOnTop() ? (FileDescr)this.context.pop() : null;
    }

    protected FileDescr peekFile() {
        return this.isFileOnTop() ? (FileDescr)this.context.peek() : null;
    }

    protected PackageDescr popPackage() {
        return this.isPackageOnTop() ? (PackageDescr)this.context.pop() : null;
    }

    protected PackageDescr peekPackage() {
        return this.isPackageOnTop() ? (PackageDescr)this.context.peek() : null;
    }

    protected ImportDescr popImport() {
        return this.isImportOnTop() ? (ImportDescr)this.context.pop() : null;
    }

    protected ImportDescr peekImport() {
        return this.isImportOnTop() ? (ImportDescr)this.context.peek() : null;
    }

    protected QualifiedNameDescr popQualifiedName() {
        return this.isQualifiedNameOnTop() ? (QualifiedNameDescr)this.context.pop() : null;
    }

    protected QualifiedNameDescr peekQualifiedName() {
        return this.isQualifiedNameOnTop() ? (QualifiedNameDescr)this.context.peek() : null;
    }

    protected IdentifierWithTypeArgumentsDescr popIdentifierWithTypeArguments() {
        return this.isIdentifierWithTypeArgumentsOnTop() ? (IdentifierWithTypeArgumentsDescr)this.context.pop() : null;
    }

    protected IdentifierWithTypeArgumentsDescr peekIdentifierWithTypeArguments() {
        return this.isIdentifierWithTypeArgumentsOnTop() ? (IdentifierWithTypeArgumentsDescr)this.context.peek() : null;
    }

    protected TypeArgumentDescr peekTypeArgument() {
        return this.isTypeArgumentOnTop() ? (TypeArgumentDescr)this.context.peek() : null;
    }

    protected HasModifiers peekHasModifiers() {
        return !this.context.empty() && this.context.peek() instanceof HasModifiers ? (HasModifiers)((Object)this.context.peek()) : null;
    }

    protected HasType peekHasType() {
        return !this.context.empty() && this.context.peek() instanceof HasType ? (HasType)((Object)this.context.peek()) : null;
    }

    protected HasClassOrInterfaceType peekHasClassOrInterfaceType() {
        return !this.context.empty() && this.context.peek() instanceof HasClassOrInterfaceType ? (HasClassOrInterfaceType)((Object)this.context.peek()) : null;
    }

    protected HasPrimitiveType peekHasPrimitiveType() {
        return !this.context.empty() && this.context.peek() instanceof HasPrimitiveType ? (HasPrimitiveType)((Object)this.context.peek()) : null;
    }

    protected HasTypeArguments peekHasTypeArguments() {
        return !this.context.empty() && this.context.peek() instanceof HasTypeArguments ? (HasTypeArguments)((Object)this.context.peek()) : null;
    }

    protected int start(CommonToken token) {
        return token != null ? token.getStartIndex() : -1;
    }

    protected int stop(CommonToken token) {
        return token != null ? token.getStopIndex() : -1;
    }

    protected int line(Token token) {
        return token != null ? token.getLine() : -1;
    }

    protected int position(Token token) {
        return token != null ? token.getCharPositionInLine() : -1;
    }

    protected int calcStart(String text, Token token) {
        return 1;
    }

    protected int calcStop(String text, Token token) {
        return 1;
    }

    protected int calcStop() {
        return 0;
    }

    protected boolean isBacktracking() {
        return this.state.backtracking > 0;
    }

    protected void updateOnAfter(ElementDescriptor element, String text, CommonToken stop) {
        element.setText(text);
        element.setStop(this.stop(stop));
    }

    protected void updateOnAfter(ElementDescriptor element, String text, CommonToken start, CommonToken stop) {
        element.setText(text);
        element.setStart(this.start(start));
        element.setLine(this.line((Token)start));
        element.setPosition(this.position((Token)start));
        element.setStop(this.stop(stop));
    }

    protected boolean isDeclaringMethodReturnType() {
        return this.declaringMethodReturnType;
    }

    protected void setDeclaringMethodReturnType(boolean declaringMethodReturnType) {
        this.declaringMethodReturnType = declaringMethodReturnType;
    }

    public void setDeclaringSuperClass(boolean declaringSuperClass) {
        this.declaringSuperClass = declaringSuperClass;
    }

    public boolean isDeclaringMainClass() {
        return this.classLevel == 1 && this.mode == ParserMode.PARSE_CLASS;
    }

    public int increaseClassLevel() {
        return ++this.classLevel;
    }

    public int decreaseClassLevel() {
        return --this.classLevel;
    }

    protected void processType(TypeDescr type) {
        if (this.isDeclaringMainClass() || this.mode == ParserMode.PARSE_FIELD || this.mode == ParserMode.PARSE_METHOD || this.mode == ParserMode.PARSE_TYPE) {
            if (this.isTypeArgumentOnTop()) {
                this.peekTypeArgument().setType(type);
            } else if (this.isFieldOnTop()) {
                this.peekField().setType(type);
            } else if (this.isMethodOnTop() && this.declaringMethodReturnType) {
                this.peekMethod().setType(type);
            } else if (this.isParameterOnTop()) {
                this.peekParameter().setType(type);
            } else if (this.isClassOnTop() && this.declaringSuperClass) {
                this.peekClass().setSuperClass(type);
            }
        }
    }

    protected void processModifiers(ModifierListDescr modifiers) {
        if ((this.isDeclaringMainClass() || this.mode == ParserMode.PARSE_FIELD || this.mode == ParserMode.PARSE_METHOD) && (this.isTypeArgumentOnTop() || this.isMethodOnTop() || this.isFieldOnTop() || this.isParameterOnTop() || this.isClassOnTop())) {
            this.peekHasModifiers().setModifiers(modifiers);
        }
    }

    protected void processMethod(MethodDescr methodDescr) {
        if (this.isDeclaringMainClass()) {
            this.getClassDescr().addMember(methodDescr);
        } else if (this.mode == ParserMode.PARSE_METHOD) {
            this.methodDescr = methodDescr;
        }
    }

    protected void setFormalParamsStart(ElementDescriptor.ElementType type, String text, int start, int stop, int line, int position) {
        if ((this.isDeclaringMainClass() || this.mode == ParserMode.PARSE_METHOD) && this.isMethodOnTop()) {
            this.peekMethod().setParamsStartParen(new JavaTokenDescr(type, text, start, stop, line, position));
        }
    }

    protected void setFormalParamsStop(ElementDescriptor.ElementType type, String text, int start, int stop, int line, int position) {
        if ((this.isDeclaringMainClass() || this.mode == ParserMode.PARSE_METHOD) && this.isMethodOnTop()) {
            this.peekMethod().setParamsStopParen(new JavaTokenDescr(type, text, start, stop, line, position));
        }
    }

    protected void processParameterList(ParameterListDescr params) {
        if ((this.isDeclaringMainClass() || this.mode == ParserMode.PARSE_METHOD) && this.isMethodOnTop()) {
            this.peekMethod().setParamsList(params);
        }
    }

    protected void processField(FieldDescr fieldDescr) {
        if (this.isDeclaringMainClass()) {
            this.getClassDescr().addMember(fieldDescr);
        } else if (this.mode == ParserMode.PARSE_FIELD) {
            this.fieldDescr = fieldDescr;
        }
    }

    protected void processClass(ClassDescr classDescr) {
        if (this.isDeclaringMainClass()) {
            this.fileDescr.setClassDescr(classDescr);
            this.context.push(classDescr);
        }
    }

    protected void processQualifiedName(QualifiedNameDescr nameDescr) {
    }

    protected void processPackage(PackageDescr packageDescr) {
        this.fileDescr.setPackageDescr(packageDescr);
    }

    protected void processImport(ImportDescr importDescr) {
        this.fileDescr.addImport(importDescr);
    }

    protected void processClassBodyStart(JavaTokenDescr bodyStart) {
        if (this.isDeclaringMainClass()) {
            this.peekClass().setBodyStartBrace(bodyStart);
        }
    }

    protected void processClassBodyStop(JavaTokenDescr bodyStop) {
        if (this.isDeclaringMainClass()) {
            this.peekClass().setBodyStopBrace(bodyStop);
        }
    }

    public static enum ParserMode {
        PARSE_CLASS,
        PARSE_METHOD,
        PARSE_FIELD,
        PARSE_ANNOTATION,
        PARSE_PACKAGE,
        PARSE_QUALIFIED_NAME,
        PARSE_TYPE;

    }
}

