/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;

public class InmutableContainerStartupStrategy
implements StartupStrategy {
    @Override
    public void startup(KieServerImpl kieServer, ContainerManager containerManager, KieServerState currentState, AtomicBoolean kieServerActive) {
        KieServerInfo kieServerInfo = kieServer.getInfoInternal();
        KieServerSetup kieServerSetup = kieServer.getController().connect(kieServerInfo);
        Set containers = kieServerSetup.getContainers();
        kieServer.addServerStatusMessage(kieServerInfo);
        if (Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) {
            containerManager.installContainersSync(kieServer, containers, currentState, kieServerSetup);
        } else {
            containerManager.installContainers(kieServer, containers, currentState, kieServerSetup);
        }
    }

    public String toString() {
        return "InmutableContainerStartupStrategy - deploys once during startup the containers selected by the controller";
    }
}

