/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.util;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class RepositoryVisitor {
    private static final Random RND = new Random();
    private File root;
    private final Map<String, String> identityHash = new ConcurrentHashMap<String, String>();
    private Map<String, String> oldIdentityHash;

    public RepositoryVisitor(Path projectPath, String projectName) {
        this(projectPath, System.getProperty("java.io.tmpdir") + File.separatorChar + "guvnor" + RND.nextLong() + File.separatorChar + projectName, false);
    }

    public RepositoryVisitor(Path projectPath, String _projectRoot, boolean cleanTempDir) {
        this.root = this.makeTempRootDirectory(_projectRoot, cleanTempDir);
        try {
            if (_projectRoot != null && !_projectRoot.equals("")) {
                this.loadIndex(this.root.getAbsolutePath());
            }
            this.visitPaths(this.root, (DirectoryStream<Path>)Files.newDirectoryStream((Path)projectPath));
            if (this.oldIdentityHash != null) {
                MapDifference difference = Maps.difference(this.oldIdentityHash, this.identityHash);
                Map deletedFiles = difference.entriesOnlyOnLeft();
                for (String path : deletedFiles.keySet()) {
                    boolean deleted = new File(this.root.getAbsolutePath().replace(projectPath.toString(), "") + "/" + path).delete();
                    System.out.println("Deleted: " + this.root.getAbsolutePath().replace(projectPath.toString(), "") + "/" + path + " -> " + deleted);
                }
            }
            this.storeIndex(this.root.getAbsolutePath());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getRoot() {
        return this.root;
    }

    private void storeIndex(String path) {
        File identityHashFile = new File(path + "/index.json");
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(this.identityHash);
        try (FileOutputStream output = new FileOutputStream(identityHashFile);){
            output.write(json.getBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(RepositoryVisitor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadIndex(String path) {
        Gson gson = new Gson();
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(path + "/index.json"));
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            this.oldIdentityHash = (Map)gson.fromJson(reader, type);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void visitPaths(File parent, DirectoryStream<Path> directoryStream) throws IOException, NoSuchAlgorithmException {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                File newParent = this.makeTempDirectory(parent, path.getFileName().toString());
                this.visitPaths(newParent, (DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            this.makeTempFile(parent, path);
        }
    }

    private File makeTempDirectory(File parent, String filePath) {
        File tempDirectory = new File(parent, filePath);
        if (tempDirectory.exists()) {
            return tempDirectory;
        }
        if (!tempDirectory.isFile()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    private File makeTempRootDirectory(String tempRoot, boolean cleanTempDir) {
        File tempRootDir = new File(tempRoot);
        if (tempRootDir.exists()) {
            if (cleanTempDir) {
                try {
                    FileUtils.deleteDirectory((File)tempRootDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            tempRootDir.mkdirs();
        }
        return tempRootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeTempFile(File parent, Path path) throws IOException, NoSuchAlgorithmException {
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        MessageDigest md = MessageDigest.getInstance("MD5");
        DigestInputStream dis = new DigestInputStream(Files.newInputStream((Path)path, (OpenOption[])new OpenOption[0]), md);
        try (BufferedInputStream origin = new BufferedInputStream(dis, 2048);){
            String resourcePath = path.toString();
            this.readFile(origin, data, 2048);
            this.identityHash.put(resourcePath, this.getMD5String(dis.getMessageDigest().digest()));
        }
        dis = new DigestInputStream(Files.newInputStream((Path)path, (OpenOption[])new OpenOption[0]), md);
        try (FileOutputStream output = null;
             BufferedInputStream origin = new BufferedInputStream(dis, 2048);){
            String resourcePath = path.toString();
            if (this.oldIdentityHash != null) {
                if (this.oldIdentityHash.containsKey(resourcePath) && this.oldIdentityHash.get(resourcePath) != null && !this.oldIdentityHash.get(resourcePath).equals(this.identityHash.get(resourcePath))) {
                    output = this.writeFile(parent, path, output, origin, data, 2048);
                    System.out.println("Overriding existing file content : " + resourcePath);
                } else if (!this.oldIdentityHash.containsKey(resourcePath)) {
                    output = this.writeFile(parent, path, output, origin, data, 2048);
                }
            } else {
                output = this.writeFile(parent, path, output, origin, data, 2048);
            }
        }
    }

    private void readFile(BufferedInputStream origin, byte[] data, int BUFFER) throws IOException {
        while (origin.read(data, 0, BUFFER) != -1) {
        }
    }

    private FileOutputStream writeFile(File parent, Path path, FileOutputStream output, BufferedInputStream origin, byte[] data, int BUFFER) throws IOException, FileNotFoundException {
        int count;
        File tempFile = new File(parent, path.getFileName().toString());
        if (!tempFile.exists()) {
            tempFile.createNewFile();
        }
        output = new FileOutputStream(tempFile);
        while ((count = origin.read(data, 0, BUFFER)) != -1) {
            output.write(data, 0, count);
        }
        return output;
    }

    public Map<String, String> getIdentityHash() {
        return this.identityHash;
    }

    private String getMD5String(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            if ((0xFF & hash[i]) < 16) {
                sb.append("0" + Integer.toHexString(0xFF & hash[i]));
                continue;
            }
            sb.append(Integer.toHexString(0xFF & hash[i]));
        }
        return sb.toString();
    }
}

