/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.ala;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.PipelineRegistry;
import org.guvnor.common.services.project.model.Module;
import org.kie.workbench.common.services.backend.builder.ala.LocalBinaryConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class BuildPipelineInvoker {
    private PipelineExecutor executor;
    private PipelineRegistry pipelineRegistry;

    public BuildPipelineInvoker() {
    }

    @Inject
    public BuildPipelineInvoker(@Named(value="buildPipelineExecutor") PipelineExecutor executor, PipelineRegistry pipelineRegistry) {
        this.executor = executor;
        this.pipelineRegistry = pipelineRegistry;
    }

    public void invokeLocalBuildPipeLine(final LocalBuildRequest buildRequest, Consumer<LocalBinaryConfig> consumer) {
        Pipeline pipe = this.pipelineRegistry.getPipelineByName("local-build-pipeline");
        Input input = new Input(){
            {
                this.put("root-path", buildRequest.getModule().getRootPath().toURI());
                this.put("build-type", buildRequest.getBuildType().name());
                if (buildRequest.isSingleResource()) {
                    this.put("resource", BuildPipelineInvoker.this.encodePath(buildRequest.getResource()));
                } else {
                    BuildPipelineInvoker.this.addResourceChanges(this, buildRequest.getResourceChanges());
                }
                if (buildRequest.getDeploymentType() != null) {
                    this.put("deployment-type", buildRequest.getDeploymentType().name());
                    this.put("suppress-handlers", Boolean.toString(buildRequest.isSuppressHandlers()));
                }
            }
        };
        this.executor.execute(input, pipe, consumer, new PipelineEventListener[0]);
    }

    public LocalBinaryConfig invokeLocalBuildPipeLine(LocalBuildRequest buildRequest) {
        LocalBinaryConfig[] result = new LocalBinaryConfig[1];
        this.invokeLocalBuildPipeLine(buildRequest, localBinaryConfig -> {
            result[0] = localBinaryConfig;
        });
        return result[0];
    }

    private void addResourceChanges(Input input, Map<Path, Collection<ResourceChange>> resourceChanges) {
        resourceChanges.entrySet().forEach(entry -> input.put((Object)this.encodeResourceChangePath((Path)entry.getKey()), (Object)this.encodeResourceChanges((Collection)entry.getValue())));
    }

    private String encodePath(Path path) {
        return path.toURI();
    }

    private String encodeResourceChangePath(Path path) {
        return "resource-change:" + this.encodePath(path);
    }

    private String encodeResourceChanges(Collection<ResourceChange> resourceChanges) {
        return resourceChanges.stream().map(change -> change.getType().name()).collect(Collectors.joining(","));
    }

    public static class LocalBuildRequest {
        private Module module;
        private LocalBuildConfig.BuildType buildType = LocalBuildConfig.BuildType.FULL_BUILD;
        private Path resource;
        private Map<Path, Collection<ResourceChange>> resourceChanges = new HashMap<Path, Collection<ResourceChange>>();
        private LocalBuildConfig.DeploymentType deploymentType;
        private boolean suppressHandlers;

        private LocalBuildRequest(Module module) {
            this.module = module;
            this.buildType = LocalBuildConfig.BuildType.FULL_BUILD;
        }

        private LocalBuildRequest(Module module, LocalBuildConfig.BuildType buildType, Path resource) {
            this.module = module;
            this.buildType = buildType;
            this.resource = resource;
        }

        private LocalBuildRequest(Module module, Map<Path, Collection<ResourceChange>> resourceChanges) {
            this.module = module;
            this.resourceChanges = resourceChanges;
            this.buildType = LocalBuildConfig.BuildType.INCREMENTAL_BATCH_CHANGES;
        }

        private LocalBuildRequest(Module module, LocalBuildConfig.DeploymentType deploymentType, boolean suppressHandlers) {
            this.module = module;
            this.deploymentType = deploymentType;
            this.suppressHandlers = suppressHandlers;
            this.buildType = LocalBuildConfig.BuildType.FULL_BUILD_AND_DEPLOY;
        }

        public static final LocalBuildRequest newFullBuildRequest(Module module) {
            return new LocalBuildRequest(module);
        }

        public static final LocalBuildRequest newFullBuildAndDeployRequest(Module module, LocalBuildConfig.DeploymentType deploymentType, boolean suppressHandlers) {
            return new LocalBuildRequest(module, deploymentType, suppressHandlers);
        }

        public static final LocalBuildRequest newIncrementalBuildRequest(Module module, LocalBuildConfig.BuildType buildType, Path resource) {
            return new LocalBuildRequest(module, buildType, resource);
        }

        public static final LocalBuildRequest newIncrementalBuildRequest(Module module, Map<Path, Collection<ResourceChange>> resourceChanges) {
            return new LocalBuildRequest(module, resourceChanges);
        }

        public LocalBuildConfig.BuildType getBuildType() {
            return this.buildType;
        }

        public Module getModule() {
            return this.module;
        }

        public Path getResource() {
            return this.resource;
        }

        public Map<Path, Collection<ResourceChange>> getResourceChanges() {
            return this.resourceChanges;
        }

        public LocalBuildConfig.DeploymentType getDeploymentType() {
            return this.deploymentType;
        }

        public boolean isSuppressHandlers() {
            return this.suppressHandlers;
        }

        public boolean isSingleResource() {
            return this.resource != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalBuildRequest that = (LocalBuildRequest)o;
            if (this.suppressHandlers != that.suppressHandlers) {
                return false;
            }
            if (this.module != null ? !this.module.equals((Object)that.module) : that.module != null) {
                return false;
            }
            if (this.buildType != that.buildType) {
                return false;
            }
            if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
                return false;
            }
            if (this.resourceChanges != null ? !this.resourceChanges.equals(that.resourceChanges) : that.resourceChanges != null) {
                return false;
            }
            return this.deploymentType == that.deploymentType;
        }

        public int hashCode() {
            int result = this.module != null ? this.module.hashCode() : 0;
            result = 31 * result + (this.buildType != null ? this.buildType.hashCode() : 0);
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            result = 31 * result + (this.resourceChanges != null ? this.resourceChanges.hashCode() : 0);
            result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
            result = 31 * result + (this.suppressHandlers ? 1 : 0);
            return result;
        }
    }
}

